/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRandomSecurityCookieFilter
implements Filter {
    protected final SecureRandom random;
    protected final String securityCookieName;

    protected AbstractRandomSecurityCookieFilter(String securityCookieName, SecureRandom random) {
        this.securityCookieName = securityCookieName;
        this.random = random;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            Cookie securityCookie = new Cookie(this.securityCookieName, new BigInteger(130, this.random).toString(32));
            securityCookie.setMaxAge(-1);
            securityCookie.setPath("/");
            httpResponse.addCookie(securityCookie);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

