/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.hibernate.Hibernate;

class PhoneHomeInfo {
    private static final String PROPERTIES_RESOURCE = "/phone.home.properties";
    private String version = PhoneHomeInfo.resolveVersion();
    private String queryString;

    PhoneHomeInfo(boolean isLocalRegion) {
        this.queryString = this.buildQueryString(isLocalRegion);
    }

    String getQueryString() {
        return this.queryString;
    }

    static String resolveVersion() {
        String string;
        block8: {
            Properties properties = new Properties();
            InputStream propertiesStream = PhoneHomeInfo.class.getResourceAsStream(PROPERTIES_RESOURCE);
            try {
                properties.load(propertiesStream);
                string = properties.getProperty("project.version", "N/A");
                if (propertiesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesStream != null) {
                        try {
                            propertiesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return "N/A";
                }
            }
            propertiesStream.close();
        }
        return string;
    }

    private String buildQueryString(boolean isLocalRegion) {
        return new QueryStringBuilder().addParam("version", this.version).addParam("hibernate-version", Hibernate.class.getPackage().getImplementationVersion()).addParam("region-type", isLocalRegion ? "local" : "distributed").build();
    }

    private static class QueryStringBuilder {
        private final ILogger logger = Logger.getLogger(QueryStringBuilder.class);
        private final StringBuilder builder = new StringBuilder("?");

        private QueryStringBuilder() {
        }

        QueryStringBuilder addParam(String key, String value) {
            if (this.builder.length() > 1) {
                this.builder.append("&");
            }
            this.builder.append(key).append("=").append(this.tryEncode(value));
            return this;
        }

        private String tryEncode(String value) {
            try {
                return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Using <unknown> for the value which couldn't be encoded: " + value, (Throwable)e);
                }
                return "unknown";
            }
        }

        String build() {
            return this.builder.toString();
        }
    }
}

