/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.map.IMap;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.SoftLock;

public class IMapRegionCache
implements RegionCache {
    private final IMap<Object, Expirable> map;
    private final String name;
    private final RegionFactory regionFactory;
    private final boolean isMember;

    public IMapRegionCache(RegionFactory regionFactory, String name, HazelcastInstance hazelcastInstance) {
        this.name = name;
        this.regionFactory = regionFactory;
        this.isMember = IMapRegionCache.isMemberInstance(hazelcastInstance);
        this.map = hazelcastInstance.getMap(this.name);
    }

    @Override
    public void afterUpdate(Object key, Object newValue, Object newVersion) {
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void evictData() {
        this.map.evictAll();
    }

    @Override
    public void evictData(Object key) {
        this.map.remove(key);
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable entry = (Expirable)this.map.get(key);
        return entry == null ? null : entry.getValue(txTimestamp);
    }

    public long getElementCountInMemory() {
        return this.isMember ? this.map.getLocalMapStats().getOwnedEntryCount() : -1L;
    }

    public String getName() {
        return this.name;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public long getSizeInMemory() {
        return this.isMember ? this.map.getLocalMapStats().getHeapCost() : -1L;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        Value newValue = new Value(version, txTimestamp, value);
        this.map.put(key, (Object)newValue);
        return true;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) {
    }

    private static boolean isMemberInstance(HazelcastInstance instance) {
        return instance.getLocalEndpoint() instanceof Member;
    }
}

