/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.google.inject.Injector;
import com.hivemq.HiveMQInstance;
import com.hivemq.bootstrap.HiveMQExceptionHandlerBootstrap;
import com.hivemq.bootstrap.LoggingBootstrap;
import com.hivemq.bootstrap.ioc.GuiceBootstrap;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.ConfigurationBootstrap;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.info.SystemInformationImpl;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.PersistenceConfigurationService;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.exceptions.StartAbortedException;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.lifecycle.LifecycleModule;
import com.hivemq.metrics.MetricRegistryLogger;
import com.hivemq.migration.MigrationUnit;
import com.hivemq.migration.Migrations;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.statistics.UsageStatistics;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMQServer {
    private static final Logger log = LoggerFactory.getLogger(HiveMQServer.class);
    @NotNull
    private final HivemqId hivemqId = new HivemqId();
    @NotNull
    private final LifecycleModule lifecycleModule = new LifecycleModule();
    @NotNull
    private final DataLock dataLock = new DataLock();
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final MetricRegistry metricRegistry;
    private final boolean migrate;
    private final boolean enableLoggingBootstrap;
    @Nullable
    private Injector injector;
    @Nullable
    private FullConfigurationService configService;

    public HiveMQServer() {
        this(new SystemInformationImpl(true), new MetricRegistry(), null, true, true);
    }

    public HiveMQServer(@NotNull SystemInformation systemInformation, @Nullable MetricRegistry metricRegistry, @Nullable FullConfigurationService configService, boolean enableLoggingBootstrap, boolean migrate) {
        this.systemInformation = systemInformation;
        this.metricRegistry = metricRegistry;
        this.configService = configService;
        this.enableLoggingBootstrap = enableLoggingBootstrap;
        this.migrate = migrate;
    }

    public static void main(String @NotNull [] args) throws Exception {
        HiveMQServer server = new HiveMQServer();
        try {
            server.start();
        }
        catch (StartAbortedException e) {
            log.info("HiveMQ start was cancelled. {}", (Object)e.getMessage());
        }
    }

    public void bootstrap() throws Exception {
        if (this.injector != null) {
            return;
        }
        this.metricRegistry.addListener((MetricRegistryListener)new MetricRegistryLogger());
        if (this.enableLoggingBootstrap) {
            LoggingBootstrap.prepareLogging();
        }
        log.info("Starting HiveMQ Community Edition Server");
        if (!this.systemInformation.isEmbedded()) {
            log.trace("Initializing HiveMQ home directory");
            this.systemInformation.init();
        }
        if (this.enableLoggingBootstrap) {
            log.trace("Initializing Logging");
            LoggingBootstrap.initLogging(this.systemInformation.getConfigFolder());
        }
        log.trace("Initializing Exception handlers");
        HiveMQExceptionHandlerBootstrap.addUnrecoverableExceptionHandler();
        if (this.configService == null) {
            log.trace("Initializing configuration");
            this.configService = ConfigurationBootstrap.bootstrapConfig(this.systemInformation);
        }
        if (this.configService.persistenceConfigurationService().getMode() == PersistenceConfigurationService.PersistenceMode.FILE) {
            log.trace("Locking data folder.");
            this.dataLock.lock(this.systemInformation.getDataFolder().toPath());
        }
        log.info("This HiveMQ ID is {}", (Object)this.hivemqId.get());
        log.trace("Cleaning up temporary folders");
        HiveMQServer.deleteTmpFolder(this.systemInformation.getDataFolder());
        log.trace("Checking for migrations");
        Map<MigrationUnit, PersistenceType> migrations = Migrations.checkForTypeMigration(this.systemInformation);
        Set<MigrationUnit> valueMigrations = Migrations.checkForValueMigration(this.systemInformation);
        log.trace("Initializing persistences");
        Injector persistenceInjector = GuiceBootstrap.persistenceInjector(this.systemInformation, this.metricRegistry, this.hivemqId, this.configService, this.lifecycleModule);
        ((PersistenceStartup)persistenceInjector.getInstance(PersistenceStartup.class)).finish();
        if (((ShutdownHooks)persistenceInjector.getInstance(ShutdownHooks.class)).isShuttingDown()) {
            throw new StartAbortedException("User aborted.");
        }
        if (this.migrate && this.configService.persistenceConfigurationService().getMode() != PersistenceConfigurationService.PersistenceMode.IN_MEMORY) {
            if (migrations.size() + valueMigrations.size() > 0) {
                if (migrations.isEmpty()) {
                    log.info("Persistence values has been changed, migrating persistent data.");
                } else {
                    log.info("Persistence types has been changed, migrating persistent data.");
                }
                for (MigrationUnit migrationUnit : migrations.keySet()) {
                    log.debug("{} needs to be migrated.", (Object)StringUtils.capitalize((String)migrationUnit.toString()));
                }
                for (MigrationUnit migrationUnit : valueMigrations) {
                    log.debug("{} needs to be migrated.", (Object)StringUtils.capitalize((String)migrationUnit.toString()));
                }
                Migrations.migrate(persistenceInjector, migrations, valueMigrations);
            }
            Migrations.afterMigration(this.systemInformation);
        }
        if (this.configService.persistenceConfigurationService().getMode().equals((Object)PersistenceConfigurationService.PersistenceMode.FILE)) {
            log.info("Starting with file persistence mode.");
        } else {
            log.info("Starting with in-memory persistence mode.");
        }
        log.trace("Initializing Guice");
        this.injector = GuiceBootstrap.bootstrapInjector(this.systemInformation, this.metricRegistry, this.hivemqId, this.configService, persistenceInjector, this.lifecycleModule);
    }

    public void startInstance(@Nullable EmbeddedExtension embeddedExtension) throws Exception {
        if (this.injector == null) {
            throw new UnrecoverableException(true);
        }
        ShutdownHooks shutdownHooks = (ShutdownHooks)this.injector.getInstance(ShutdownHooks.class);
        if (shutdownHooks.isShuttingDown()) {
            throw new StartAbortedException("User aborted.");
        }
        HiveMQInstance instance = (HiveMQInstance)this.injector.getInstance(HiveMQInstance.class);
        log.trace("Starting initial garbage collection after startup");
        long start = System.currentTimeMillis();
        System.gc();
        log.trace("Finished initial garbage collection after startup in {}ms", (Object)(System.currentTimeMillis() - start));
        if (shutdownHooks.isShuttingDown()) {
            throw new StartAbortedException("User aborted.");
        }
        if (this.enableLoggingBootstrap) {
            LoggingBootstrap.addLoglevelModifiers();
        }
        instance.start(embeddedExtension);
    }

    public void afterStart() {
        if (this.injector == null) {
            return;
        }
        ShutdownHooks shutdownHooks = (ShutdownHooks)this.injector.getInstance(ShutdownHooks.class);
        if (shutdownHooks.isShuttingDown()) {
            throw new StartAbortedException("User aborted.");
        }
        UsageStatistics usageStatistics = (UsageStatistics)this.injector.getInstance(UsageStatistics.class);
        usageStatistics.start();
    }

    public void start() throws Exception {
        long startTime = System.nanoTime();
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop, "shutdown-thread," + this.hivemqId.get()));
        this.bootstrap();
        this.startInstance(null);
        log.info("Started HiveMQ in {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        this.afterStart();
    }

    public void stop() {
        if (this.injector == null) {
            return;
        }
        ShutdownHooks shutdownHooks = (ShutdownHooks)this.injector.getInstance(ShutdownHooks.class);
        if (shutdownHooks.isShuttingDown()) {
            return;
        }
        shutdownHooks.runShutdownHooks();
        if (this.configService.persistenceConfigurationService().getMode() == PersistenceConfigurationService.PersistenceMode.FILE) {
            this.dataLock.unlock();
        }
        if (this.enableLoggingBootstrap) {
            LoggingBootstrap.resetLogging();
        }
    }

    @Nullable
    public Injector getInjector() {
        return this.injector;
    }

    private static void deleteTmpFolder(@NotNull File dataFolder) {
        block2: {
            String tmpFolder = dataFolder.getPath() + File.separator + "tmp";
            try {
                FileUtils.deleteDirectory((File)new File(tmpFolder));
            }
            catch (IOException e) {
                log.warn("The temporary folder could not be deleted ({}).", (Object)tmpFolder);
                if (!log.isDebugEnabled()) break block2;
                log.debug("Original Exception: ", (Throwable)e);
            }
        }
    }

    private static final class DataLock {
        @Nullable
        private FileChannel channel;
        @Nullable
        private FileLock fileLock;

        private DataLock() {
        }

        public void lock(@NotNull Path dataPath) {
            Path lockFile = dataPath.resolve("data.lock");
            try {
                this.channel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            }
            catch (Throwable e) {
                log.error("Could not open data lock file.", e);
                throw new StartAbortedException("An error occurred while opening the persistence. Is another HiveMQ instance running?");
            }
            try {
                this.fileLock = this.channel.tryLock();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.fileLock == null) {
                throw new StartAbortedException("An error occurred while opening the persistence. Is another HiveMQ instance running?");
            }
        }

        public void unlock() {
            try {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
            }
            catch (IOException e) {
                log.error("An error occurred while releasing lock of data folder.");
            }
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                log.error("An error occurred while closing lock file in data folder.");
            }
        }
    }
}

