/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.bootstrap.UndefinedClientConnection;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.client.ClientAuthenticators;
import com.hivemq.extensions.client.ClientAuthorizers;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.client.parameter.ConnectionAttributes;
import com.hivemq.extensions.events.client.parameters.ClientEventListeners;
import com.hivemq.mqtt.handler.publish.PublishFlushHandler;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.pool.FreePacketIdRanges;
import com.hivemq.security.auth.SslClientCertificate;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnection
implements ClientConnectionContext {
    @NotNull
    private final Channel channel;
    @NotNull
    private final PublishFlushHandler publishFlushHandler;
    @NotNull
    private final FreePacketIdRanges freePacketIdRanges = new FreePacketIdRanges();
    @NotNull
    private final Listener connectedListener;
    @NotNull
    private volatile ClientState clientState;
    @NotNull
    private ProtocolVersion protocolVersion;
    @NotNull
    private String clientId;
    private boolean cleanStart;
    @Nullable
    private ModifiableDefaultPermissions authPermissions;
    @Nullable
    private MqttWillPublish willPublish;
    @Nullable
    private AtomicInteger inFlightMessageCount;
    @Nullable
    private Integer clientReceiveMaximum;
    @Nullable
    private Integer connectKeepAlive;
    @Nullable
    private Long queueSizeMaximum;
    @Nullable
    private Long clientSessionExpiryInterval;
    @Nullable
    private Long connectReceivedTimestamp;
    @Nullable
    private Long maxPacketSizeSend;
    private @NotNull String @Nullable [] topicAliasMapping;
    private boolean noSharedSubscription;
    private boolean clientIdAssigned;
    private boolean incomingPublishesSkipRest;
    private boolean incomingPublishesDefaultFailedSkipRest;
    private boolean requestResponseInformation;
    @Nullable
    private Boolean requestProblemInformation;
    @Nullable
    private SettableFuture<Void> disconnectFuture;
    @Nullable
    private ConnectionAttributes connectionAttributes;
    private boolean sendWill;
    private boolean preventLwt;
    private boolean inFlightMessagesSent;
    @Nullable
    private SslClientCertificate authCertificate;
    @Nullable
    private String authSniHostname;
    @Nullable
    private String authCipherSuite;
    @Nullable
    private String authProtocol;
    @Nullable
    private String authUsername;
    private byte @Nullable [] authPassword;
    @Nullable
    private CONNECT authConnect;
    @Nullable
    private String authMethod;
    @Nullable
    private ByteBuffer authData;
    @Nullable
    private Mqtt5UserProperties authUserProperties;
    @Nullable
    private ScheduledFuture<?> authFuture;
    @Nullable
    private Boolean clearPasswordAfterAuth;
    @Nullable
    private ClientContextImpl extensionClientContext;
    @Nullable
    private ClientEventListeners extensionClientEventListeners;
    @Nullable
    private ClientAuthenticators extensionClientAuthenticators;
    @Nullable
    private ClientAuthorizers extensionClientAuthorizers;
    @Nullable
    private ClientInformation extensionClientInformation;
    @Nullable
    private ConnectionInformation extensionConnectionInformation;

    @NotNull
    public static ClientConnection of(@NotNull Channel channel) {
        ClientConnectionContext clientConnectionContext = (ClientConnectionContext)channel.attr(ClientConnectionContext.CHANNEL_ATTRIBUTE_NAME).get();
        Preconditions.checkArgument((boolean)(clientConnectionContext instanceof ClientConnection));
        return (ClientConnection)clientConnectionContext;
    }

    @NotNull
    public static ClientConnection from(@NotNull ClientConnectionContext clientConnectionContext) {
        Preconditions.checkArgument((boolean)(clientConnectionContext instanceof UndefinedClientConnection));
        UndefinedClientConnection context = (UndefinedClientConnection)clientConnectionContext;
        Preconditions.checkNotNull((Object)context.clientId, (Object)"Client id must not be null.");
        Preconditions.checkNotNull((Object)((Object)context.clientState), (Object)"Client state must not be null.");
        Preconditions.checkNotNull((Object)((Object)context.protocolVersion), (Object)"Protocol version must not be null.");
        Preconditions.checkNotNull((Object)context.connectedListener, (Object)"Connected listener must not be null.");
        ClientConnection clientConnection = new ClientConnection(context.channel, context.publishFlushHandler, context.clientState, context.protocolVersion, context.clientId, context.cleanStart, context.authPermissions, context.connectedListener, context.willPublish, context.clientReceiveMaximum, context.connectKeepAlive, context.queueSizeMaximum, context.clientSessionExpiryInterval, context.connectReceivedTimestamp, context.topicAliasMapping, context.clientIdAssigned, context.incomingPublishesSkipRest, context.requestResponseInformation, context.requestProblemInformation, context.disconnectFuture, context.connectionAttributes, context.sendWill, context.preventLwt, context.authCertificate, context.authSniHostname, context.authCipherSuite, context.authProtocol, context.authUsername, context.authPassword, context.authConnect, context.authMethod, context.authData, context.authUserProperties, context.authFuture, context.maxPacketSizeSend, context.extensionClientContext, context.extensionClientEventListeners, context.extensionClientAuthenticators, context.extensionClientAuthorizers, context.extensionClientInformation, context.extensionConnectionInformation);
        context.getChannel().attr(ClientConnectionContext.CHANNEL_ATTRIBUTE_NAME).set((Object)clientConnection);
        return clientConnection;
    }

    public ClientConnection(@NotNull Channel channel, @NotNull PublishFlushHandler publishFlushHandler, @NotNull ClientState clientState, @NotNull ProtocolVersion protocolVersion, @NotNull String clientId, boolean cleanStart, @Nullable ModifiableDefaultPermissions authPermissions, @NotNull Listener connectedListener, @Nullable MqttWillPublish mqttWillPublish, @Nullable Integer clientReceiveMaximum, @Nullable Integer connectKeepAlive, @Nullable Long queueSizeMaximum, @Nullable Long clientSessionExpiryInterval, @Nullable Long connectReceivedTimestamp, @NotNull String @Nullable [] topicAliasMapping, boolean clientIdAssigned, boolean incomingPublishesSkipRest, boolean requestResponseInformation, @Nullable Boolean requestProblemInformation, @Nullable SettableFuture<Void> disconnectFuture, @Nullable ConnectionAttributes connectionAttributes, boolean sendWill, boolean preventLwt, @Nullable SslClientCertificate authCertificate, @Nullable String authSniHostname, @Nullable String authCipherSuite, @Nullable String authProtocol, @Nullable String authUsername, byte @Nullable [] authPassword, @Nullable CONNECT authConnect, @Nullable String authMethod, @Nullable ByteBuffer authData, @Nullable Mqtt5UserProperties authUserProperties, @Nullable ScheduledFuture<?> authFuture, @Nullable Long maxPacketSizeSend, @Nullable ClientContextImpl extensionClientContext, @Nullable ClientEventListeners extensionClientEventListeners, @Nullable ClientAuthenticators extensionClientAuthenticators, @Nullable ClientAuthorizers extensionClientAuthorizers, @Nullable ClientInformation extensionClientInformation, @Nullable ConnectionInformation extensionConnectionInformation) {
        this.channel = channel;
        this.publishFlushHandler = publishFlushHandler;
        this.clientState = clientState;
        this.protocolVersion = protocolVersion;
        this.clientId = clientId;
        this.cleanStart = cleanStart;
        this.authPermissions = authPermissions;
        this.connectedListener = connectedListener;
        this.willPublish = mqttWillPublish;
        this.clientReceiveMaximum = clientReceiveMaximum;
        this.connectKeepAlive = connectKeepAlive;
        this.queueSizeMaximum = queueSizeMaximum;
        this.clientSessionExpiryInterval = clientSessionExpiryInterval;
        this.connectReceivedTimestamp = connectReceivedTimestamp;
        this.topicAliasMapping = topicAliasMapping;
        this.clientIdAssigned = clientIdAssigned;
        this.incomingPublishesSkipRest = incomingPublishesSkipRest;
        this.requestResponseInformation = requestResponseInformation;
        this.requestProblemInformation = requestProblemInformation;
        this.disconnectFuture = disconnectFuture;
        this.connectionAttributes = connectionAttributes;
        this.sendWill = sendWill;
        this.preventLwt = preventLwt;
        this.authCertificate = authCertificate;
        this.authSniHostname = authSniHostname;
        this.authCipherSuite = authCipherSuite;
        this.authProtocol = authProtocol;
        this.authUsername = authUsername;
        this.authPassword = authPassword;
        this.authConnect = authConnect;
        this.authMethod = authMethod;
        this.authData = authData;
        this.authUserProperties = authUserProperties;
        this.authFuture = authFuture;
        this.maxPacketSizeSend = maxPacketSizeSend;
        this.extensionClientContext = extensionClientContext;
        this.extensionClientEventListeners = extensionClientEventListeners;
        this.extensionClientAuthenticators = extensionClientAuthenticators;
        this.extensionClientAuthorizers = extensionClientAuthorizers;
        this.extensionClientInformation = extensionClientInformation;
        this.extensionConnectionInformation = extensionConnectionInformation;
    }

    @Override
    @NotNull
    public Channel getChannel() {
        return this.channel;
    }

    @NotNull
    public PublishFlushHandler getPublishFlushHandler() {
        return this.publishFlushHandler;
    }

    @Override
    @NotNull
    public ClientState getClientState() {
        return this.clientState;
    }

    @Override
    public void proposeClientState(@NotNull ClientState clientState) {
        if (!this.clientState.disconnected()) {
            this.clientState = clientState;
        }
    }

    @VisibleForTesting
    public void setClientStateUnsafe(@NotNull ClientState clientState) {
        this.clientState = clientState;
    }

    @Override
    @NotNull
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolVersion(@Nullable ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@NotNull String clientId) {
        this.clientId = clientId;
    }

    public boolean isCleanStart() {
        return this.cleanStart;
    }

    @Override
    public void setCleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
    }

    @Override
    @Nullable
    public ModifiableDefaultPermissions getAuthPermissions() {
        return this.authPermissions;
    }

    @Override
    public void setAuthPermissions(@NotNull ModifiableDefaultPermissions authPermissions) {
        this.authPermissions = authPermissions;
    }

    @Override
    @NotNull
    public Listener getConnectedListener() {
        return this.connectedListener;
    }

    @Nullable
    public MqttWillPublish getWillPublish() {
        return this.willPublish;
    }

    @Override
    public void setWillPublish(@Nullable MqttWillPublish willPublish) {
        this.willPublish = willPublish;
    }

    @Nullable
    public AtomicInteger getInFlightMessageCount() {
        return this.inFlightMessageCount;
    }

    public void setInFlightMessageCount(@Nullable AtomicInteger inFlightMessageCount) {
        this.inFlightMessageCount = inFlightMessageCount;
    }

    @Override
    @Nullable
    public Integer getClientReceiveMaximum() {
        return this.clientReceiveMaximum;
    }

    @Override
    public void setClientReceiveMaximum(@NotNull Integer clientReceiveMaximum) {
        this.clientReceiveMaximum = clientReceiveMaximum;
    }

    @Nullable
    public Integer getConnectKeepAlive() {
        return this.connectKeepAlive;
    }

    @Override
    public void setConnectKeepAlive(@NotNull Integer connectKeepAlive) {
        this.connectKeepAlive = connectKeepAlive;
    }

    @Override
    @Nullable
    public Long getQueueSizeMaximum() {
        return this.queueSizeMaximum;
    }

    @Override
    public void setQueueSizeMaximum(@Nullable Long queueSizeMaximum) {
        this.queueSizeMaximum = queueSizeMaximum;
    }

    @NotNull
    public FreePacketIdRanges getFreePacketIdRanges() {
        return this.freePacketIdRanges;
    }

    public int inFlightMessageCount() {
        if (this.inFlightMessageCount == null) {
            return 0;
        }
        return this.inFlightMessageCount.get();
    }

    public int decrementInFlightCount() {
        if (this.inFlightMessageCount == null) {
            return 0;
        }
        return this.inFlightMessageCount.decrementAndGet();
    }

    public int incrementInFlightCount() {
        if (this.inFlightMessageCount == null) {
            this.inFlightMessageCount = new AtomicInteger();
        }
        return this.inFlightMessageCount.incrementAndGet();
    }

    @Override
    @Nullable
    public Long getClientSessionExpiryInterval() {
        return this.clientSessionExpiryInterval;
    }

    @Override
    public void setClientSessionExpiryInterval(@NotNull Long clientSessionExpiryInterval) {
        this.clientSessionExpiryInterval = clientSessionExpiryInterval;
    }

    @Override
    @Nullable
    public Long getConnectReceivedTimestamp() {
        return this.connectReceivedTimestamp;
    }

    @Override
    public void setConnectReceivedTimestamp(@NotNull Long connectReceivedTimestamp) {
        this.connectReceivedTimestamp = connectReceivedTimestamp;
    }

    @Override
    @Nullable
    public Long getMaxPacketSizeSend() {
        return this.maxPacketSizeSend;
    }

    @Override
    public void setMaxPacketSizeSend(@NotNull Long maxPacketSizeSend) {
        this.maxPacketSizeSend = maxPacketSizeSend;
    }

    @Override
    public @NotNull String @Nullable [] getTopicAliasMapping() {
        return this.topicAliasMapping;
    }

    @Override
    public void setTopicAliasMapping(@NotNull @NotNull String @NotNull [] topicAliasMapping) {
        this.topicAliasMapping = topicAliasMapping;
    }

    public boolean getNoSharedSubscription() {
        return this.noSharedSubscription;
    }

    public void setNoSharedSubscription(boolean noSharedSubscription) {
        this.noSharedSubscription = noSharedSubscription;
    }

    @Override
    public boolean isClientIdAssigned() {
        return this.clientIdAssigned;
    }

    @Override
    public void setClientIdAssigned(boolean clientIdAssigned) {
        this.clientIdAssigned = clientIdAssigned;
    }

    @Override
    public boolean isIncomingPublishesSkipRest() {
        return this.incomingPublishesSkipRest;
    }

    @Override
    public void setIncomingPublishesSkipRest(boolean incomingPublishesSkipRest) {
        this.incomingPublishesSkipRest = incomingPublishesSkipRest;
    }

    public boolean isIncomingPublishesDefaultFailedSkipRest() {
        return this.incomingPublishesDefaultFailedSkipRest;
    }

    public void setIncomingPublishesDefaultFailedSkipRest(boolean incomingPublishesDefaultFailedSkipRest) {
        this.incomingPublishesDefaultFailedSkipRest = incomingPublishesDefaultFailedSkipRest;
    }

    @Override
    public boolean isRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    @Override
    public void setRequestResponseInformation(boolean requestResponseInformation) {
        this.requestResponseInformation = requestResponseInformation;
    }

    @Override
    @Nullable
    public Boolean getRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    @Override
    public void setRequestProblemInformation(boolean requestProblemInformation) {
        this.requestProblemInformation = requestProblemInformation;
    }

    @Override
    @Nullable
    public SettableFuture<Void> getDisconnectFuture() {
        return this.disconnectFuture;
    }

    @Override
    public void setDisconnectFuture(@NotNull SettableFuture<Void> disconnectFuture) {
        this.disconnectFuture = disconnectFuture;
    }

    @Override
    @Nullable
    public ConnectionAttributes getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Override
    @NotNull
    public synchronized ConnectionAttributes setConnectionAttributesIfAbsent(@NotNull ConnectionAttributes connectionAttributes) {
        if (this.connectionAttributes == null) {
            this.connectionAttributes = connectionAttributes;
        }
        return this.connectionAttributes;
    }

    public boolean isSendWill() {
        return this.sendWill;
    }

    @Override
    public void setSendWill(boolean sendWill) {
        this.sendWill = sendWill;
    }

    public boolean isPreventLwt() {
        return this.preventLwt;
    }

    @Override
    public void setPreventLwt(boolean preventLwt) {
        this.preventLwt = preventLwt;
    }

    public boolean isInFlightMessagesSent() {
        return this.inFlightMessagesSent;
    }

    public void setInFlightMessagesSent(boolean inFlightMessagesSent) {
        this.inFlightMessagesSent = inFlightMessagesSent;
    }

    public boolean isMessagesInFlight() {
        return !this.inFlightMessagesSent || this.inFlightMessageCount() > 0;
    }

    @Override
    @Nullable
    public SslClientCertificate getAuthCertificate() {
        return this.authCertificate;
    }

    @Override
    public void setAuthCertificate(@NotNull SslClientCertificate authCertificate) {
        this.authCertificate = authCertificate;
    }

    @Override
    @Nullable
    public String getAuthSniHostname() {
        return this.authSniHostname;
    }

    @Override
    public void setAuthSniHostname(@NotNull String authSniHostname) {
        this.authSniHostname = authSniHostname;
    }

    @Override
    @Nullable
    public String getAuthCipherSuite() {
        return this.authCipherSuite;
    }

    @Override
    public void setAuthCipherSuite(@NotNull String authCipherSuite) {
        this.authCipherSuite = authCipherSuite;
    }

    @Override
    @Nullable
    public String getAuthProtocol() {
        return this.authProtocol;
    }

    @Override
    public void setAuthProtocol(@NotNull String authProtocol) {
        this.authProtocol = authProtocol;
    }

    @Nullable
    public String getAuthUsername() {
        return this.authUsername;
    }

    @Override
    public void setAuthUsername(@NotNull String authUsername) {
        this.authUsername = authUsername;
    }

    public byte @Nullable [] getAuthPassword() {
        return this.authPassword;
    }

    @Override
    public void setAuthPassword(byte @Nullable [] authPassword) {
        this.authPassword = authPassword;
    }

    @Override
    @Nullable
    public CONNECT getAuthConnect() {
        return this.authConnect;
    }

    @Override
    public void setAuthConnect(@Nullable CONNECT authConnect) {
        this.authConnect = authConnect;
    }

    @Override
    @Nullable
    public String getAuthMethod() {
        return this.authMethod;
    }

    @Override
    public void setAuthMethod(@NotNull String authMethod) {
        this.authMethod = authMethod;
    }

    @Override
    @Nullable
    public ByteBuffer getAuthData() {
        return this.authData;
    }

    @Override
    public void setAuthData(@Nullable ByteBuffer authData) {
        this.authData = authData;
    }

    @Override
    @Nullable
    public Mqtt5UserProperties getAuthUserProperties() {
        return this.authUserProperties;
    }

    @Override
    public void setAuthUserProperties(@Nullable Mqtt5UserProperties authUserProperties) {
        this.authUserProperties = authUserProperties;
    }

    @Override
    @Nullable
    public ScheduledFuture<?> getAuthFuture() {
        return this.authFuture;
    }

    @Override
    public void setAuthFuture(@Nullable ScheduledFuture<?> authFuture) {
        this.authFuture = authFuture;
    }

    @Override
    @Nullable
    public ClientContextImpl getExtensionClientContext() {
        return this.extensionClientContext;
    }

    @Override
    public void setExtensionClientContext(@NotNull ClientContextImpl extensionClientContext) {
        this.extensionClientContext = extensionClientContext;
    }

    @Override
    @Nullable
    public ClientEventListeners getExtensionClientEventListeners() {
        return this.extensionClientEventListeners;
    }

    @Override
    public void setExtensionClientEventListeners(@NotNull ClientEventListeners extensionClientEventListeners) {
        this.extensionClientEventListeners = extensionClientEventListeners;
    }

    @Override
    @Nullable
    public ClientAuthorizers getExtensionClientAuthorizers() {
        return this.extensionClientAuthorizers;
    }

    @Override
    public void setExtensionClientAuthorizers(@NotNull ClientAuthorizers extensionClientAuthorizers) {
        this.extensionClientAuthorizers = extensionClientAuthorizers;
    }

    @Override
    @Nullable
    public ClientInformation getExtensionClientInformation() {
        return this.extensionClientInformation;
    }

    @Override
    public void setExtensionClientInformation(@NotNull ClientInformation extensionClientInformation) {
        this.extensionClientInformation = extensionClientInformation;
    }

    @Override
    @Nullable
    public ConnectionInformation getExtensionConnectionInformation() {
        return this.extensionConnectionInformation;
    }

    @Override
    public void setExtensionConnectionInformation(@NotNull ConnectionInformation extensionConnectionInformation) {
        this.extensionConnectionInformation = extensionConnectionInformation;
    }

    @Override
    @Nullable
    public ClientAuthenticators getExtensionClientAuthenticators() {
        return this.extensionClientAuthenticators;
    }

    @Override
    public void setExtensionClientAuthenticators(@NotNull ClientAuthenticators extensionClientAuthenticators) {
        this.extensionClientAuthenticators = extensionClientAuthenticators;
    }

    public int getMaxInflightWindow(int defaultMaxInflightWindow) {
        if (this.clientReceiveMaximum == null) {
            return defaultMaxInflightWindow;
        }
        return Math.min(this.clientReceiveMaximum, defaultMaxInflightWindow);
    }

    @Override
    @NotNull
    public Optional<String> getChannelIP() {
        Optional<InetAddress> inetAddress = this.getChannelAddress();
        return inetAddress.map(InetAddress::getHostAddress);
    }

    @Override
    @NotNull
    public Optional<InetAddress> getChannelAddress() {
        SocketAddress sockAddress;
        Optional<SocketAddress> socketAddress = Optional.ofNullable(this.channel.remoteAddress());
        if (socketAddress.isPresent() && (sockAddress = socketAddress.get()) instanceof InetSocketAddress) {
            return Optional.ofNullable(((InetSocketAddress)sockAddress).getAddress());
        }
        return Optional.empty();
    }

    @Override
    public void setClearPasswordAfterAuth(@Nullable Boolean clearPasswordAfterAuth) {
        this.clearPasswordAfterAuth = clearPasswordAfterAuth;
    }

    @Override
    @NotNull
    public Optional<Boolean> isClearPasswordAfterAuth() {
        return Optional.ofNullable(this.clearPasswordAfterAuth);
    }

    @Override
    public void clearPassword() {
        if (this.authPassword == null) {
            return;
        }
        Arrays.fill(this.authPassword, (byte)0);
        this.authPassword = null;
    }
}

