/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.Optional;

public class ListenerStartupInformation {
    private final boolean successful;
    @NotNull
    private final Listener listener;
    @Nullable
    private final Throwable exception;

    private ListenerStartupInformation(boolean successful, @NotNull Listener listener, @Nullable Throwable exception) {
        Preconditions.checkNotNull((Object)listener, (Object)"Original Listener must not be null");
        this.successful = successful;
        this.listener = listener;
        this.exception = exception;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    @NotNull
    public Listener getListener() {
        return this.listener;
    }

    @NotNull
    public Optional<Throwable> getException() {
        return Optional.ofNullable(this.exception);
    }

    public static ListenerStartupInformation successfulListenerStartup(@NotNull Listener listener) {
        return new ListenerStartupInformation(true, listener, null);
    }

    public static ListenerStartupInformation failedListenerStartup(@NotNull Listener listener, @Nullable Throwable exception) {
        return new ListenerStartupInformation(false, listener, exception);
    }
}

