/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.ioc;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Stage;
import com.hivemq.bootstrap.ioc.HiveMQMainModule;
import com.hivemq.bootstrap.ioc.SystemInformationModule;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingletonModule;
import com.hivemq.bootstrap.netty.ioc.NettyModule;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.configuration.ioc.ConfigurationModule;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.diagnostic.DiagnosticModule;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.ioc.ExtensionModule;
import com.hivemq.lifecycle.LifecycleModule;
import com.hivemq.metrics.ioc.MetricsModule;
import com.hivemq.mqtt.ioc.MQTTHandlerModule;
import com.hivemq.mqtt.ioc.MQTTServiceModule;
import com.hivemq.persistence.ioc.PersistenceMigrationModule;
import com.hivemq.persistence.ioc.PersistenceModule;
import com.hivemq.security.ioc.SecurityModule;
import com.hivemq.statistics.UsageStatisticsModule;
import com.hivemq.throttling.ioc.ThrottlingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBootstrap {
    private static final Logger log = LoggerFactory.getLogger(GuiceBootstrap.class);

    @Nullable
    public static Injector bootstrapInjector(@NotNull SystemInformation systemInformation, @NotNull MetricRegistry metricRegistry, @NotNull HivemqId hiveMQId, @NotNull FullConfigurationService fullConfigurationService, @NotNull Injector persistenceInjector, @NotNull LifecycleModule lifecycleModule) {
        if (!Boolean.parseBoolean(System.getProperty("diagnosticMode"))) {
            log.trace("Turning Guice stack traces off");
            System.setProperty("guice_include_stack_traces", "OFF");
        }
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new AbstractModule[]{new SystemInformationModule(systemInformation), new LazySingletonModule(), lifecycleModule, new ConfigurationModule(fullConfigurationService, hiveMQId), new NettyModule(), new HiveMQMainModule(), new MQTTHandlerModule(persistenceInjector), new PersistenceModule(persistenceInjector, fullConfigurationService.persistenceConfigurationService()), new MetricsModule(metricRegistry, persistenceInjector), new ThrottlingModule(), new MQTTServiceModule(), new DiagnosticModule(), new SecurityModule(), new UsageStatisticsModule(), new ExtensionModule()});
        try {
            return Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules.build());
        }
        catch (Exception e) {
            log.error("Initializing Guice aborted", (Throwable)e);
            if (log.isDebugEnabled()) {
                log.debug("Original Exception: ", (Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    public static Injector persistenceInjector(@NotNull SystemInformation systemInformation, @NotNull MetricRegistry metricRegistry, @NotNull HivemqId hiveMQId, @NotNull FullConfigurationService configService, @NotNull LifecycleModule lifecycleModule) {
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new AbstractModule[]{new SystemInformationModule(systemInformation), new ConfigurationModule(configService, hiveMQId), new LazySingletonModule(), lifecycleModule, new PersistenceMigrationModule(metricRegistry, configService.persistenceConfigurationService())});
        return Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)modules.build());
    }
}

