/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty.initializer;

import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.bootstrap.netty.initializer.AbstractTlsChannelInitializer;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.security.exception.SslException;
import com.hivemq.security.ssl.SslFactory;
import com.hivemq.websocket.WebSocketInitializer;
import io.netty.channel.Channel;

public class TlsWebsocketChannelInitializer
extends AbstractTlsChannelInitializer {
    @NotNull
    private final TlsWebsocketListener tlsWebsocketListener;

    public TlsWebsocketChannelInitializer(@NotNull ChannelDependencies channelDependencies, @NotNull TlsWebsocketListener tlsWebsocketListener, @NotNull SslFactory sslFactory) {
        super(channelDependencies, tlsWebsocketListener, sslFactory);
        this.tlsWebsocketListener = tlsWebsocketListener;
    }

    @Override
    protected void addSpecialHandlers(@NotNull Channel ch) throws SslException {
        super.addSpecialHandlers(ch);
        Tls.ClientAuthMode authMode = this.tlsWebsocketListener.getTls().getClientAuthMode();
        String handlerName = !Tls.ClientAuthMode.NONE.equals((Object)authMode) ? "ssl_client_certificate_handler" : "ssl_parameter_handler";
        new WebSocketInitializer(this.tlsWebsocketListener).addHandlers(ch, handlerName);
    }
}

