/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty.ioc;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hivemq.bootstrap.netty.NettyConfiguration;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class NettyConfigurationProvider
implements Provider<NettyConfiguration> {
    @NotNull
    public NettyConfiguration get() {
        EventLoopGroup parentGroup = this.createParentEventLoop();
        EventLoopGroup childGroup = this.createChildEventLoop();
        return new NettyConfiguration(NioServerSocketChannel.class, NioSocketChannel.class, parentGroup, childGroup);
    }

    @NotNull
    private EventLoopGroup createParentEventLoop() {
        return new NioEventLoopGroup(1, this.createThreadFactory("hivemq-eventloop-parent-%d"));
    }

    @NotNull
    private EventLoopGroup createChildEventLoop() {
        return new NioEventLoopGroup(0, this.createThreadFactory("hivemq-eventloop-child-%d"));
    }

    private ThreadFactory createThreadFactory(@NotNull String nameFormat) {
        Preconditions.checkNotNull((Object)nameFormat, (Object)"Thread Factory Name Format must not be null");
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }
}

