/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.decoder.MqttDecoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.util.Strings;
import com.hivemq.util.Topics;
import io.netty.buffer.ByteBuf;

public abstract class AbstractMqttDecoder<T extends Message>
extends MqttDecoder<T> {
    protected static final int DISCONNECTED = -1;
    @NotNull
    protected final FullConfigurationService configurationService;
    @NotNull
    protected final MqttServerDisconnector disconnector;
    protected final boolean validateUTF8;
    protected final boolean subscriptionIdentifiersAvailable;
    protected final long maxMessageExpiryInterval;
    protected final long maxUserPropertiesLength;

    protected AbstractMqttDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        this.configurationService = configurationService;
        this.disconnector = disconnector;
        this.validateUTF8 = configurationService.securityConfiguration().validateUTF8();
        this.maxMessageExpiryInterval = configurationService.mqttConfiguration().maxMessageExpiryInterval();
        this.maxUserPropertiesLength = 0x500000L;
        this.subscriptionIdentifiersAvailable = configurationService.mqttConfiguration().subscriptionIdentifierEnabled();
    }

    @Nullable
    protected ImmutableList.Builder<MqttUserProperty> readUserProperty(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder, @NotNull MessageType messageType) {
        MqttUserProperty userProperty = MqttUserProperty.decode(buf, this.validateUTF8);
        if (userProperty == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed user property. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed user property", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s containing a malformed user property was sent.", messageType.name()));
            return null;
        }
        if (userPropertiesBuilder == null) {
            userPropertiesBuilder = ImmutableList.builder();
        }
        userPropertiesBuilder.add((Object)userProperty);
        return userPropertiesBuilder;
    }

    protected int decodeUTF8StringLength(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull String key, @NotNull MessageType messageType) {
        int utf8StringLength;
        block3: {
            block2: {
                if (buf.readableBytes() < 2) break block2;
                utf8StringLength = buf.readUnsignedShort();
                if (buf.readableBytes() >= utf8StringLength) break block3;
            }
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with an incorrect UTF-8 string length for '" + key + "'. Disconnecting client.", "Incorrect " + messageType.name() + " UTF-8 string length for '" + key + "'", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with incorrect UTF-8 String length for %s was sent.", messageType.name(), key));
            return -1;
        }
        return utf8StringLength;
    }

    @Nullable
    protected String decodeUTF8Topic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull String key, @NotNull MessageType messageType) {
        int utf8StringLength = this.decodeUTF8StringLength(clientConnectionContext, buf, key, messageType);
        if (utf8StringLength == -1) {
            return null;
        }
        return this.decodeUTF8Topic(clientConnectionContext, buf, utf8StringLength, key, messageType);
    }

    @Nullable
    protected String decodeUTF8Topic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int utf8StringLength, @NotNull String key, @NotNull MessageType messageType) {
        String utf8String = Strings.getValidatedPrefixedString(buf, utf8StringLength, this.validateUTF8);
        if (utf8String == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed '" + key + "'. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with malformed UTF-8 String for '" + key + "'", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed UTF-8 String for %s was sent.", messageType.name(), key));
        }
        return utf8String;
    }

    @Nullable
    protected String decodeAuthenticationMethod(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String authenticationMethod, @NotNull MessageType messageType) {
        if (authenticationMethod != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "auth method", messageType);
            return null;
        }
        authenticationMethod = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (authenticationMethod == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed auth method. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with malformed UTF-8 String for auth method", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed authentication method was sent.", messageType.name()));
            return null;
        }
        return authenticationMethod;
    }

    protected boolean topicInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull String parameterName, @NotNull String topicName) {
        if (topicName.isEmpty()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (ID: {}, IP: {}) sent a PUBLISH with an empty " + parameterName + ". This is not allowed. Disconnecting client.", "Sent a PUBLISH with an empty " + parameterName, Mqtt5DisconnectReasonCode.TOPIC_NAME_INVALID, String.format("PUBLISH with empty %s.", parameterName));
            return true;
        }
        if (Topics.containsWildcard(topicName)) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (ID: {}, IP: {}) sent a PUBLISH with a wildcard character (# or +). This is not allowed. Disconnecting client.", "Sent a PUBLISH with wildcard character (#/+) in topic: " + topicName, Mqtt5DisconnectReasonCode.TOPIC_NAME_INVALID, String.format("%s with wildcard character (#/+) was sent.", "PUBLISH"));
            return true;
        }
        return false;
    }

    protected byte @Nullable [] readCorrelationData(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte @Nullable [] correlationData, @NotNull MessageType messageType) {
        if (correlationData != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "correlation data", messageType);
            return null;
        }
        correlationData = MqttBinaryData.decode(buf);
        if (correlationData == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed correlation data. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed correlation data", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed correlation data was sent.", messageType.name()));
        }
        return correlationData;
    }

    @Nullable
    protected String readResponseTopic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String responseTopic, @NotNull MessageType messageType) {
        if (responseTopic != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "response topic", messageType);
            return null;
        }
        responseTopic = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (responseTopic == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed UTF-8 string for response topic. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed UTF-8 string for response topic", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed response topic was sent.", messageType.name()));
            return null;
        }
        if (this.topicInvalid(clientConnectionContext, "response topic", responseTopic)) {
            return null;
        }
        return responseTopic;
    }

    @Nullable
    protected String readContentType(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String contentType, @NotNull MessageType messageType) {
        if (contentType != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "content type", messageType);
            return null;
        }
        contentType = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (contentType == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed UTF-8 string for content type. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed UTF-8 string for content type", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed UTF-8 String for content type was sent.", messageType.name()));
            return null;
        }
        return contentType;
    }

    @Nullable
    protected Mqtt5PayloadFormatIndicator readPayloadFormatIndicator(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @NotNull MessageType messageType) {
        if (payloadFormatIndicator != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "payload format indicator", messageType);
            return null;
        }
        if (buf.readableBytes() < 1) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, messageType);
            return null;
        }
        short payloadFormatIndicatorByte = buf.readUnsignedByte();
        payloadFormatIndicator = Mqtt5PayloadFormatIndicator.fromCode(payloadFormatIndicatorByte);
        if (payloadFormatIndicator == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a wrong payload format indicator. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a wrong payload format indicator", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with invalid payload format indicator was sent.", messageType.name()));
            return null;
        }
        return payloadFormatIndicator;
    }

    protected boolean messageExpiryIntervalInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long messageExpiryInterval, @NotNull MessageType messageType) {
        if (messageExpiryInterval != Long.MAX_VALUE) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "message expiry interval", messageType);
            return true;
        }
        if (buf.readableBytes() < 4) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, messageType);
            return true;
        }
        return false;
    }

    protected int decodePropertiesLengthNoPayload(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull MessageType messageType) {
        int propertyLength = MqttVariableByteInteger.decode(buf);
        if (propertyLength < 0) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, messageType);
            return -1;
        }
        if (buf.readableBytes() != propertyLength) {
            if (buf.readableBytes() < propertyLength) {
                this.disconnectByRemainingLengthToShort(clientConnectionContext, messageType);
            } else {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with payload. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with payload", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s containing a payload was sent.", messageType.name()));
            }
            return -1;
        }
        return propertyLength;
    }

    protected long decodeSessionExpiryInterval(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long sessionExpiryInterval, long sessionExpiryNotSet, @NotNull MessageType messageType) {
        if (sessionExpiryInterval != sessionExpiryNotSet) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "session expiry interval", messageType);
            return -1L;
        }
        if (buf.readableBytes() < 4) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, messageType);
            return -1L;
        }
        return buf.readUnsignedInt();
    }

    @Nullable
    protected String decodeServerReference(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String serverReference, @NotNull MessageType messageType) {
        if (serverReference != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "server reference", messageType);
            return null;
        }
        serverReference = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (serverReference == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed UTF-8 string for server reference. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed UTF-8 string for server reference", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with a malformed UTF-8 String in server reference was sent.", messageType.name()));
            return null;
        }
        return serverReference;
    }

    @Nullable
    protected String decodeReasonString(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String reasonString, @NotNull MessageType messageType) {
        if (reasonString != null) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "reason string", messageType);
            return null;
        }
        reasonString = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (reasonString == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed UTF-8 string for reason string. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed UTF-8 string for reason string", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed UTF-8 String for reason string was sent.", messageType.name()));
            return null;
        }
        return reasonString;
    }

    protected void disconnectByInvalidReasonCode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with invalid reason code. Disconnecting client.", "Sent a " + messageType.name() + " with invalid reason code", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, String.format("%s with invalid reason code was sent. This is a protocol violation.", messageType.name()));
    }

    protected void disconnectByInvalidAuthMethod(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with invalid authentication method. Disconnecting client.", "Sent a " + messageType.name() + " with invalid authentication method", Mqtt5DisconnectReasonCode.BAD_AUTHENTICATION_METHOD, String.format("%s with invalid authentication method was sent.", messageType.name()));
    }

    protected void disconnectByMoreThanOnce(@NotNull ClientConnectionContext clientConnectionContext, @NotNull String key, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with '" + key + "' included more than once. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with '" + key + "' included more than once", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, String.format("%s with %s included more than once was sent. This is a protocol violation.", messageType.name(), key));
    }

    protected void disconnectByRemainingLengthToShort(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with remaining length too short. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with remaining length too short", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with not enough remaining read buffer length was sent.", messageType.name()));
    }

    protected void disconnectByMalformedPropertyLength(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with a malformed properties length. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with a malformed properties length", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with malformed properties length was sent.", messageType.name()));
    }

    protected void disconnectByInvalidPropertyIdentifier(@NotNull ClientConnectionContext clientConnectionContext, int propertyIdentifier, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with an invalid property identifier '" + propertyIdentifier + "'. This is not allowed. Disconnecting client.", "Sent a " + messageType.name() + " with invalid property identifier", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with invalid property identifier was sent.", messageType.name()));
    }

    protected void disconnectByInvalidFixedHeader(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with an invalid fixed header. Disconnecting client.", "Sent a " + messageType.name() + " with invalid fixed header", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with incorrect fixed header was sent.", messageType.name()));
    }

    protected void disconnectByNoMessageId(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType) {
        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " without a message id. Disconnecting client.", "Sent a " + messageType.name() + " without message id", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, String.format("%s without message id was sent.", messageType.name()));
    }

    protected int decodePacketIdentifier(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull MessageType messageType) {
        int packetIdentifier = buf.readUnsignedShort();
        if (packetIdentifier == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with message ID 0. Disconnecting client.", "Sent a " + messageType.name() + " with message id 0", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, String.format("%s with a packet identifier of '0' was sent. This is a protocol violation.", messageType.name()));
        }
        return packetIdentifier;
    }

    protected boolean invalidUserPropertiesLength(@NotNull ClientConnectionContext clientConnectionContext, @NotNull MessageType messageType, @NotNull Mqtt5UserProperties userProperties) {
        if ((long)userProperties.encodedLength() > this.maxUserPropertiesLength) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a " + messageType.name() + " with user properties that are too large. Disconnecting client.", "Sent a " + messageType.name() + " with too large user properties", Mqtt5DisconnectReasonCode.PACKET_TOO_LARGE, String.format("Sent %s with too large user properties.", messageType.name()));
            return true;
        }
        return false;
    }
}

