/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.util.Strings;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt3SubscribeDecoder
extends AbstractMqttDecoder<SUBSCRIBE> {
    @Inject
    public Mqtt3SubscribeDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public SUBSCRIBE decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1_1) {
            if ((header & 0xF) != 2) {
                this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.SUBSCRIBE);
                buf.clear();
                return null;
            }
        } else if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1 && (header & 0xF) > 3) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.SUBSCRIBE);
            buf.clear();
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByNoMessageId(clientConnectionContext, MessageType.SUBSCRIBE);
            buf.clear();
            return null;
        }
        int messageId = buf.readUnsignedShort();
        if (messageId < 1) {
            this.disconnectByNoMessageId(clientConnectionContext, MessageType.SUBSCRIBE);
            buf.clear();
            return null;
        }
        ImmutableList.Builder topics = new ImmutableList.Builder();
        if (!buf.isReadable()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE which didn't contain any subscription. This is not allowed. Disconnecting client.", "Sent SUBSCRIBE without any subscriptions", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with zero subscriptions was sent.");
            buf.clear();
            return null;
        }
        while (buf.isReadable()) {
            String topic = Strings.getPrefixedString(buf);
            if (Mqtt3SubscribeDecoder.isInvalidTopic(clientConnectionContext, topic)) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), null, "Sent SUBSCRIBE with an invalid topic filter", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "Sent SUBSCRIBE with an invalid topic filter.");
                return null;
            }
            if (buf.readableBytes() == 0) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE message without QoS. Disconnecting client.", "Sent SUBSCRIBE without QoS", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE without a quality of service level was sent. This is a protocol violation.");
                buf.clear();
                return null;
            }
            byte qos = buf.readByte();
            if (qos < 0 || qos > 2) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with an invalid qos '3'. This is not allowed. Disconnecting client.", "Invalid SUBSCRIBE with invalid qos '3'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with a quality of service level set to '3' was sent. This is a protocol violation.");
                buf.clear();
                return null;
            }
            topics.add((Object)new Topic(topic, QoS.valueOf(qos)));
        }
        return new SUBSCRIBE((ImmutableList<Topic>)topics.build(), messageId);
    }
}

