/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttPublishDecoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.limitation.TopicAliasLimiter;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.publish.Mqtt5PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt5PublishDecoder
extends AbstractMqttPublishDecoder<Mqtt5PUBLISH> {
    @NotNull
    private final HivemqId hiveMQId;
    @NotNull
    private final TopicAliasLimiter topicAliasLimiter;
    private final boolean validatePayloadFormat;

    @Inject
    public Mqtt5PublishDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull HivemqId hiveMQId, @NotNull FullConfigurationService fullConfigurationService, @NotNull TopicAliasLimiter topicAliasLimiter) {
        super(disconnector, fullConfigurationService);
        this.hiveMQId = hiveMQId;
        this.topicAliasLimiter = topicAliasLimiter;
        this.validatePayloadFormat = fullConfigurationService.securityConfiguration().payloadFormatValidation();
    }

    @Override
    @Nullable
    public Mqtt5PUBLISH decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        PUBLISHFactory.Mqtt5Builder publishBuilder;
        int packetIdentifier;
        int qos = this.decodeQoS(clientConnectionContext, header);
        if (qos == -1) {
            return null;
        }
        Boolean dup = this.decodeDup(clientConnectionContext, header, qos);
        if (dup == null) {
            return null;
        }
        Boolean retain = this.decodeRetain(clientConnectionContext, header);
        if (retain == null) {
            return null;
        }
        String topicName = this.decodeUTF8Topic(clientConnectionContext, buf, "topic", MessageType.PUBLISH);
        if (topicName == null) {
            return null;
        }
        if (topicName.isEmpty()) {
            topicName = null;
        } else if (this.topicInvalid(clientConnectionContext, "topic", topicName)) {
            return null;
        }
        if (qos > 0) {
            if (buf.readableBytes() < 2) {
                this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBLISH);
                return null;
            }
            packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf);
            if (packetIdentifier == 0) {
                return null;
            }
        } else {
            packetIdentifier = 0;
        }
        if ((publishBuilder = this.readPublishPropertiesAndPayload(clientConnectionContext, buf, topicName)) == null) {
            return null;
        }
        return publishBuilder.withHivemqId(this.hiveMQId.get()).withQoS(QoS.valueOf(qos)).withOnwardQos(QoS.valueOf(qos)).withRetain(retain).withPacketIdentifier(packetIdentifier).withDuplicateDelivery(dup).build();
    }

    private PUBLISHFactory.Mqtt5Builder readPublishPropertiesAndPayload(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String topicName) {
        int readPropertyLength;
        int propertiesLength = MqttVariableByteInteger.decode(buf);
        if (this.propertiesLengthInvalid(clientConnectionContext, buf, propertiesLength)) {
            return null;
        }
        long messageExpiryInterval = Long.MAX_VALUE;
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = null;
        String contentType = null;
        String responseTopic = null;
        byte[] correlationData = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        int topicAlias = -1;
        int propertiesStartIndex = buf.readerIndex();
        block10: while ((readPropertyLength = buf.readerIndex() - propertiesStartIndex) < propertiesLength) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 2: {
                    if (this.messageExpiryIntervalInvalid(clientConnectionContext, buf, messageExpiryInterval, MessageType.PUBLISH)) {
                        return null;
                    }
                    messageExpiryInterval = buf.readUnsignedInt();
                    continue block10;
                }
                case 1: {
                    if ((payloadFormatIndicator = this.readPayloadFormatIndicator(clientConnectionContext, buf, payloadFormatIndicator, MessageType.PUBLISH)) != null) continue block10;
                    return null;
                }
                case 3: {
                    if ((contentType = this.readContentType(clientConnectionContext, buf, contentType, MessageType.PUBLISH)) != null) continue block10;
                    return null;
                }
                case 8: {
                    if ((responseTopic = this.readResponseTopic(clientConnectionContext, buf, responseTopic, MessageType.PUBLISH)) != null) continue block10;
                    return null;
                }
                case 9: {
                    if ((correlationData = this.readCorrelationData(clientConnectionContext, buf, correlationData, MessageType.PUBLISH)) != null) continue block10;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.PUBLISH)) != null) continue block10;
                    return null;
                }
                case 35: {
                    if (this.topicAliasInvalid(clientConnectionContext, buf, topicAlias)) {
                        return null;
                    }
                    topicAlias = buf.readUnsignedShort();
                    if (topicAlias != 0) continue block10;
                    this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with topic alias = '0'. This is not allowed. Disconnecting client.", "Sent a PUBLISH with topic alias = '0'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBLISH containing topic alias of '0' was sent.");
                    return null;
                }
                case 11: {
                    this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with subscription identifiers. This is not allowed. Disconnecting client.", "Sent PUBLISH with subscription identifiers", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBLISH containing subscription identifiers was sent. This is a protocol violation.");
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.PUBLISH);
            return null;
        }
        if (readPropertyLength != propertiesLength) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.PUBLISH);
            return null;
        }
        PUBLISHFactory.Mqtt5Builder publishBuilder = this.readTopicFromAliasMapping(clientConnectionContext, topicName, topicAlias);
        if (publishBuilder == null) {
            return null;
        }
        byte[] payload = this.decodePayload(clientConnectionContext, buf, buf.readableBytes(), payloadFormatIndicator, this.validatePayloadFormat);
        if (payload == null) {
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.PUBLISH, userProperties)) {
            return null;
        }
        if (messageExpiryInterval > this.maxMessageExpiryInterval) {
            messageExpiryInterval = this.maxMessageExpiryInterval;
        }
        return publishBuilder.withMessageExpiryInterval(messageExpiryInterval).withPayloadFormatIndicator(payloadFormatIndicator).withContentType(contentType).withResponseTopic(responseTopic).withCorrelationData(correlationData).withUserProperties(userProperties).withPayload(payload);
    }

    @Nullable
    private PUBLISHFactory.Mqtt5Builder readTopicFromAliasMapping(@NotNull ClientConnectionContext clientConnectionContext, @Nullable String topicName, int topicAlias) {
        boolean isNewTopicAlias = false;
        if (topicAlias != -1) {
            String[] topicAliasMapping = clientConnectionContext.getTopicAliasMapping();
            if (topicAliasMapping == null || topicAlias > topicAliasMapping.length) {
                this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with a too large topic alias. This is not allowed. Disconnecting client.", "Sent a PUBLISH with too large topic alias", Mqtt5DisconnectReasonCode.TOPIC_ALIAS_INVALID, "Topic alias in PUBLISH sent was too large.");
                return null;
            }
            if (topicName == null) {
                topicName = topicAliasMapping[topicAlias - 1];
                if (topicName == null) {
                    this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with an unmapped topic alias. This is not allowed. Disconnecting client.", "Sent a PUBLISH with an unmapped topic alias", Mqtt5DisconnectReasonCode.TOPIC_ALIAS_INVALID, "Topic alias in PUBLISH could not be mapped.");
                    return null;
                }
            } else {
                String previous = topicAliasMapping[topicAlias - 1];
                if (previous != null) {
                    this.topicAliasLimiter.removeUsage(previous);
                }
                topicAliasMapping[topicAlias - 1] = topicName;
                this.topicAliasLimiter.addUsage(topicName);
                if (this.topicAliasLimiter.limitExceeded()) {
                    this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with a Topic Alias that exceeds the global memory hard limit. Disconnecting client.", "Sent a PUBLISH with a Topic Alias that exceeds the global memory hard limit", Mqtt5DisconnectReasonCode.QUOTA_EXCEEDED, "Topic alias in PUBLISH exceeds the global memory hard limit.");
                    return null;
                }
                isNewTopicAlias = true;
            }
        } else if (topicName == null) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PUBLISH with absent topic alias while topic name is zero length. This is not allowed. Disconnecting client.", "Sent a PUBLISH with absent topic alias while topic name is zero length", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "PUBLISH missing both topic name and topic alias was sent.");
            return null;
        }
        return new PUBLISHFactory.Mqtt5Builder().withNewTopicAlias(isNewTopicAlias).withTopic(topicName);
    }

    private boolean topicAliasInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int topicAlias) {
        if (topicAlias != -1) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "topic alias", MessageType.PUBLISH);
            return true;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBLISH);
            return true;
        }
        return false;
    }

    private boolean propertiesLengthInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int propertyLength) {
        if (propertyLength < 0) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.PUBLISH);
            return true;
        }
        if (buf.readableBytes() < propertyLength) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBLISH);
            return true;
        }
        return false;
    }
}

