/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.pubrel.Mqtt5PUBREL;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.message.reason.Mqtt5PubRelReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;

@LazySingleton
public class Mqtt5PubrelDecoder
extends AbstractMqttDecoder<PUBREL> {
    @Inject
    public Mqtt5PubrelDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public PUBREL decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.PUBREL);
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBREL);
            return null;
        }
        int packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf, MessageType.PUBREL);
        if (packetIdentifier == 0) {
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBREL(packetIdentifier, Mqtt5PUBREL.DEFAULT_REASON_CODE, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        Mqtt5PubRelReasonCode reasonCode = Mqtt5PubRelReasonCode.fromCode(buf.readUnsignedByte());
        if (reasonCode == null) {
            this.disconnectByInvalidReasonCode(clientConnectionContext, MessageType.PUBREL);
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBREL(packetIdentifier, reasonCode, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        int propertiesLength = this.decodePropertiesLengthNoPayload(clientConnectionContext, buf, MessageType.PUBREL);
        if (propertiesLength == -1) {
            return null;
        }
        String reasonString = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        block4: while (buf.isReadable()) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 31: {
                    if ((reasonString = this.decodeReasonString(clientConnectionContext, buf, reasonString, MessageType.PUBREL)) != null) continue block4;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.PUBREL)) != null) continue block4;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.PUBREL);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.PUBREL, userProperties)) {
            return null;
        }
        return new PUBREL(packetIdentifier, reasonCode, reasonString, userProperties);
    }

    @Override
    protected boolean validateHeader(byte header) {
        return (header & 2) == 2;
    }
}

