/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import io.netty.buffer.ByteBuf;

public class Mqtt3PubcompEncoder
implements MqttEncoder<PUBCOMP> {
    public static final int ENCODED_PUBCOMP_SIZE = 4;
    private static final byte PUBCOMP_FIXED_HEADER = 112;
    private static final byte PUBCOMP_REMAINING_LENGTH = 2;

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBCOMP msg, @NotNull ByteBuf out) {
        if (msg.getPacketIdentifier() == 0) {
            throw new IllegalArgumentException("Message ID must not be null");
        }
        out.writeByte(112);
        out.writeByte(2);
        out.writeShort(msg.getPacketIdentifier());
    }

    @Override
    public int bufferSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull PUBCOMP msg) {
        return 4;
    }
}

