/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.publish.PUBLISH;
import io.netty.buffer.ByteBuf;
import javax.inject.Singleton;

@Singleton
public class Mqtt5PublishEncoder
extends Mqtt5MessageWithUserPropertiesEncoder<PUBLISH> {
    private static final int FIXED_HEADER = MessageType.PUBLISH.ordinal() << 4;

    public Mqtt5PublishEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    void encode(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        Mqtt5PublishEncoder.encodeFixedHeader(publish, out);
        this.encodeVariableHeader(publish, out);
        Mqtt5PublishEncoder.encodePayload(publish, out);
    }

    @Override
    int calculateRemainingLengthWithoutProperties(@NotNull PUBLISH publish) {
        byte[] payload;
        int remainingLength = 0;
        remainingLength += MqttBinaryData.encodedLength(publish.getTopic());
        if (publish.getQoS() != QoS.AT_MOST_ONCE) {
            remainingLength += 2;
        }
        if ((payload = publish.getPayload()) != null) {
            remainingLength += payload.length;
        }
        return remainingLength;
    }

    @Override
    int calculatePropertyLength(@NotNull PUBLISH publish) {
        int propertyLength = 0;
        propertyLength += Mqtt5PublishEncoder.fixedPropertyLength(publish);
        propertyLength += publish.getUserProperties().encodedLength();
        ImmutableIntArray subscriptionIdentifiers = publish.getSubscriptionIdentifiers();
        if (subscriptionIdentifiers != null) {
            for (int i = 0; i < subscriptionIdentifiers.length(); ++i) {
                propertyLength += Mqtt5MessageEncoderUtil.variableByteIntegerPropertyEncodedLength(subscriptionIdentifiers.get(i));
            }
        }
        return propertyLength;
    }

    @Override
    @NotNull
    Mqtt5UserProperties getUserProperties(@NotNull PUBLISH publish) {
        return publish.getUserProperties();
    }

    private static int fixedPropertyLength(@NotNull PUBLISH publish) {
        int propertyLength = 0;
        propertyLength += Mqtt5MessageEncoderUtil.intPropertyEncodedLength(publish.getMessageExpiryInterval(), 0x100000000L);
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getPayloadFormatIndicator());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getContentType());
        propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getResponseTopic());
        return propertyLength += Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(publish.getCorrelationData());
    }

    private static void encodeFixedHeader(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        int flags = 0;
        if (publish.isDuplicateDelivery()) {
            flags |= 8;
        }
        flags |= publish.getQoS().ordinal() << 1;
        if (publish.isRetain()) {
            flags |= 1;
        }
        out.writeByte(FIXED_HEADER | flags);
        MqttVariableByteInteger.encode(publish.getRemainingLength(), out);
    }

    private void encodeVariableHeader(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        MqttBinaryData.encode(publish.getTopic(), out);
        if (publish.getQoS() != QoS.AT_MOST_ONCE) {
            out.writeShort(publish.getPacketIdentifier());
        }
        this.encodeProperties(publish, out);
    }

    private void encodeProperties(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        MqttVariableByteInteger.encode(publish.getPropertyLength(), out);
        Mqtt5PublishEncoder.encodeFixedProperties(publish, out);
        this.encodeOmissibleProperties(publish, out);
        ImmutableIntArray subscriptionIdentifiers = publish.getSubscriptionIdentifiers();
        if (subscriptionIdentifiers != null) {
            for (int i = 0; i < subscriptionIdentifiers.length(); ++i) {
                Mqtt5MessageEncoderUtil.encodeVariableByteIntegerProperty(11, subscriptionIdentifiers.get(i), out);
            }
        }
    }

    private static void encodeFixedProperties(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        Mqtt5MessageEncoderUtil.encodeIntProperty(2, publish.getMessageExpiryInterval(), 0x100000000L, out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(1, publish.getPayloadFormatIndicator(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(3, publish.getContentType(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(8, publish.getResponseTopic(), out);
        Mqtt5MessageEncoderUtil.encodeNullableProperty(9, publish.getCorrelationData(), out);
    }

    private static void encodePayload(@NotNull PUBLISH publish, @NotNull ByteBuf out) {
        byte[] payload = publish.getPayload();
        if (payload != null) {
            out.writeBytes(payload);
        }
    }
}

