/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.reader;

import com.hivemq.configuration.entity.RestrictionsEntity;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionConfigurator {
    private static final Logger log = LoggerFactory.getLogger(RestrictionConfigurator.class);
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;

    public RestrictionConfigurator(@NotNull RestrictionsConfigurationService restrictionsConfigurationService) {
        this.restrictionsConfigurationService = restrictionsConfigurationService;
    }

    void setRestrictionsConfig(@NotNull RestrictionsEntity restrictionsEntity) {
        this.restrictionsConfigurationService.setMaxConnections(this.validateMaxConnections(restrictionsEntity.getMaxConnections()));
        this.restrictionsConfigurationService.setMaxClientIdLength(this.validateMaxClientIdLength(restrictionsEntity.getMaxClientIdLength()));
        this.restrictionsConfigurationService.setNoConnectIdleTimeout(this.validateNoConnectIdleTimeout(restrictionsEntity.getNoConnectIdleTimeout()));
        this.restrictionsConfigurationService.setIncomingLimit(this.validateIncomingLimit(restrictionsEntity.getIncomingBandwidthThrottling()));
        this.restrictionsConfigurationService.setMaxTopicLength(this.validateMaxTopicLength(restrictionsEntity.getMaxTopicLength()));
    }

    private long validateMaxConnections(long maxConnections) {
        if (maxConnections == -1L) {
            return maxConnections;
        }
        if (maxConnections < 0L) {
            log.warn("The configured max-connections ({}) must be at least {}. The default value (unlimited) is used instead.", (Object)maxConnections, (Object)0L);
            return -1L;
        }
        return maxConnections;
    }

    private int validateMaxClientIdLength(int maxClientIdLength) {
        if (maxClientIdLength < 1 || maxClientIdLength > 65535) {
            log.warn("The configured max-client-id-length ({}) must be in the range {} - {}. The default value ({}) is used instead.", new Object[]{maxClientIdLength, 1, 65535, 65535});
            return 65535;
        }
        return maxClientIdLength;
    }

    private int validateMaxTopicLength(int maxTopicLength) {
        if (maxTopicLength < 1 || maxTopicLength > 65535) {
            log.warn("The configured max-topic-length ({}) must be in the range {} - {}. The default value ({}) is used instead.", new Object[]{maxTopicLength, 1, 65535, 65535});
            return 65535;
        }
        return maxTopicLength;
    }

    private long validateNoConnectIdleTimeout(long noConnectIdleTimeout) {
        if (noConnectIdleTimeout < 1L) {
            log.warn("The configured no-connect-idle-timeout ({}ms) must be at least {}ms. The default value ({}ms) is used instead.", new Object[]{noConnectIdleTimeout, 1L, 10000L});
            return 10000L;
        }
        return noConnectIdleTimeout;
    }

    private long validateIncomingLimit(long incomingLimit) {
        if (incomingLimit < 0L) {
            log.warn("The configured incoming-bandwidth-throttling ({} bytes/second) must be at least {} bytes/second. The default value (unlimited) is used instead.", (Object)incomingLimit, (Object)0L);
            return 0L;
        }
        return incomingLimit;
    }
}

