/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.QoS;

public interface MqttConfigurationService {
    public long maxQueuedMessages();

    public long maxSessionExpiryInterval();

    public long maxMessageExpiryInterval();

    public int serverReceiveMaximum();

    public int maxPacketSize();

    public QueuedMessagesStrategy getQueuedMessagesStrategy();

    public boolean retainedMessagesEnabled();

    public boolean wildcardSubscriptionsEnabled();

    public QoS maximumQos();

    public boolean topicAliasEnabled();

    public int topicAliasMaxPerClient();

    public boolean subscriptionIdentifierEnabled();

    public boolean sharedSubscriptionsEnabled();

    public boolean keepAliveAllowZero();

    public int keepAliveMax();

    public void setQueuedMessagesStrategy(@NotNull QueuedMessagesStrategy var1);

    public void setMaxPacketSize(int var1);

    public void setServerReceiveMaximum(int var1);

    public void setMaxQueuedMessages(long var1);

    public void setMaxSessionExpiryInterval(long var1);

    public void setMaxMessageExpiryInterval(long var1);

    public void setRetainedMessagesEnabled(boolean var1);

    public void setWildcardSubscriptionsEnabled(boolean var1);

    public void setMaximumQos(QoS var1);

    public void setTopicAliasEnabled(boolean var1);

    public void setTopicAliasMaxPerClient(int var1);

    public void setSubscriptionIdentifierEnabled(boolean var1);

    public void setSharedSubscriptionsEnabled(boolean var1);

    public void setKeepAliveAllowZero(boolean var1);

    public void setKeepAliveMax(int var1);

    public static enum QueuedMessagesStrategy {
        DISCARD_OLDEST(0),
        DISCARD(1);

        @NotNull
        private static final @NotNull QueuedMessagesStrategy @NotNull [] VALUES;
        private final int index;

        private QueuedMessagesStrategy(int index) {
            this.index = index;
        }

        @NotNull
        public static QueuedMessagesStrategy valueOf(int index) {
            try {
                return VALUES[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("No queued messages strategy for index " + index, e);
            }
        }

        public int getIndex() {
            return this.index;
        }

        static {
            VALUES = QueuedMessagesStrategy.values();
        }
    }
}

