/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.configuration.service.entity.TlsListener;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;

public class TlsWebsocketListener
extends WebsocketListener
implements TlsListener {
    @NotNull
    private final Tls tls;

    private TlsWebsocketListener(int port, @NotNull String bindAddress, @NotNull String path, @NotNull Boolean allowExtensions, @NotNull List<String> subprotocols, @NotNull Tls tls, @NotNull String name) {
        super(port, bindAddress, path, allowExtensions, subprotocols, name);
        this.tls = tls;
    }

    @Override
    @NotNull
    public Tls getTls() {
        return this.tls;
    }

    @Override
    @NotNull
    public String readableName() {
        return "Websocket Listener with TLS";
    }

    public static class Builder {
        @NotNull
        protected String path = "";
        @NotNull
        protected List<String> subprotocols = new ArrayList<String>();
        @Nullable
        protected String name;
        @Nullable
        protected Integer port;
        @Nullable
        protected String bindAddress;
        protected boolean allowExtensions;
        @Nullable
        private Tls tls;

        public Builder() {
            this.subprotocols.add("mqtt");
            this.allowExtensions = false;
        }

        @NotNull
        public Builder from(@NotNull TlsWebsocketListener tlsWebsocketListener) {
            this.port = tlsWebsocketListener.getPort();
            this.bindAddress = tlsWebsocketListener.getBindAddress();
            this.path = tlsWebsocketListener.getPath();
            this.name = tlsWebsocketListener.getName();
            this.allowExtensions = tlsWebsocketListener.getAllowExtensions();
            this.subprotocols = new ArrayList<String>(tlsWebsocketListener.getSubprotocols());
            this.tls = tlsWebsocketListener.getTls();
            return this;
        }

        @NotNull
        public Builder tls(@NotNull Tls tls) {
            Preconditions.checkNotNull((Object)tls);
            this.tls = tls;
            return this;
        }

        @NotNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder bindAddress(@NotNull String bindAddress) {
            Preconditions.checkNotNull((Object)bindAddress);
            this.bindAddress = bindAddress;
            return this;
        }

        @NotNull
        public Builder path(@NotNull String path) {
            Preconditions.checkNotNull((Object)path);
            this.path = path;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        @NotNull
        public Builder allowExtensions(boolean allowExtensions) {
            this.allowExtensions = allowExtensions;
            return this;
        }

        @NotNull
        public Builder subprotocols(@NotNull List<String> subprotocols) {
            Preconditions.checkNotNull(subprotocols);
            this.subprotocols = ImmutableList.copyOf(subprotocols);
            return this;
        }

        @NotNull
        public TlsWebsocketListener build() {
            if (this.port == null) {
                throw new IllegalStateException("The port for a TLS Websocket listener was not set.");
            }
            if (this.bindAddress == null) {
                throw new IllegalStateException("The bind address for a TLS Websocket listener was not set.");
            }
            if (this.name == null) {
                this.name = "tls-websocket-listener-" + this.port;
            }
            if (this.tls == null) {
                throw new IllegalStateException("The TLS settings for a TLS Websocket listener was not set.");
            }
            return new TlsWebsocketListener(this.port, this.bindAddress, this.path, this.allowExtensions, this.subprotocols, this.tls, this.name);
        }
    }
}

