/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.impl;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.entity.mqtt.MqttConfigurationDefaults;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.QoS;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttConfigurationServiceImpl
implements MqttConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(MqttConfigurationServiceImpl.class);
    private final AtomicLong maxClientSessionExpiryInterval = new AtomicLong(0xFFFFFFFFL);
    private final AtomicLong maxMessageExpiryInterval = new AtomicLong(0x100000000L);
    private final AtomicInteger serverReceiveMaximum = new AtomicInteger(10);
    private final AtomicInteger maxPacketSize = new AtomicInteger(0x10000004);
    private final AtomicLong maxQueuedMessages = new AtomicLong(1000L);
    private final AtomicReference<MqttConfigurationService.QueuedMessagesStrategy> queuedMessagesStrategy = new AtomicReference<MqttConfigurationService.QueuedMessagesStrategy>(MqttConfigurationDefaults.QUEUED_MESSAGES_STRATEGY_DEFAULT);
    private final AtomicBoolean retainedMessagesEnabled = new AtomicBoolean(true);
    private final AtomicBoolean wildcardSubscriptionsEnabled = new AtomicBoolean(true);
    private final AtomicBoolean topicAliasEnabled = new AtomicBoolean(true);
    private final AtomicInteger topicAliasMaxPerClient = new AtomicInteger(5);
    private final AtomicBoolean subscriptionIdentifierEnabled = new AtomicBoolean(true);
    private final AtomicBoolean sharedSubscriptionsEnabled = new AtomicBoolean(true);
    private final AtomicBoolean keepAliveAllowZero = new AtomicBoolean(true);
    private final AtomicInteger keepAliveMax = new AtomicInteger(65535);
    private final AtomicReference<QoS> maximumQos = new AtomicReference<QoS>(MqttConfigurationDefaults.MAXIMUM_QOS_DEFAULT);

    @Override
    public long maxQueuedMessages() {
        return this.maxQueuedMessages.get();
    }

    @Override
    public long maxSessionExpiryInterval() {
        return this.maxClientSessionExpiryInterval.get();
    }

    @Override
    public long maxMessageExpiryInterval() {
        return this.maxMessageExpiryInterval.get();
    }

    @Override
    public int serverReceiveMaximum() {
        return this.serverReceiveMaximum.get();
    }

    @Override
    public int maxPacketSize() {
        return this.maxPacketSize.get();
    }

    @Override
    @NotNull
    public MqttConfigurationService.QueuedMessagesStrategy getQueuedMessagesStrategy() {
        return this.queuedMessagesStrategy.get();
    }

    @Override
    public boolean retainedMessagesEnabled() {
        return this.retainedMessagesEnabled.get();
    }

    @Override
    public boolean wildcardSubscriptionsEnabled() {
        return this.wildcardSubscriptionsEnabled.get();
    }

    @Override
    @NotNull
    public QoS maximumQos() {
        return this.maximumQos.get();
    }

    @Override
    public boolean topicAliasEnabled() {
        return this.topicAliasEnabled.get();
    }

    @Override
    public int topicAliasMaxPerClient() {
        return this.topicAliasMaxPerClient.get();
    }

    @Override
    public boolean subscriptionIdentifierEnabled() {
        return this.subscriptionIdentifierEnabled.get();
    }

    @Override
    public boolean sharedSubscriptionsEnabled() {
        return this.sharedSubscriptionsEnabled.get();
    }

    @Override
    public boolean keepAliveAllowZero() {
        return this.keepAliveAllowZero.get();
    }

    @Override
    public int keepAliveMax() {
        return this.keepAliveMax.get();
    }

    @Override
    public void setQueuedMessagesStrategy(@NotNull MqttConfigurationService.QueuedMessagesStrategy strategy) {
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Queued Messages strategy must not be null");
        log.debug("Setting queued messages strategy for each client to {}", (Object)strategy.name());
        this.queuedMessagesStrategy.set(strategy);
    }

    @Override
    public void setMaxPacketSize(int maxPacketSize) {
        log.debug("Setting the maximum packet size for mqtt messages {} bytes", (Object)maxPacketSize);
        this.maxPacketSize.set(maxPacketSize);
    }

    @Override
    public void setMaxQueuedMessages(long maxQueuedMessages) {
        log.debug("Setting the number of max queued messages  per client to {} entries", (Object)maxQueuedMessages);
        this.maxQueuedMessages.set(maxQueuedMessages);
    }

    @Override
    public void setMaxSessionExpiryInterval(long maxClientSessionExpiryInterval) {
        log.debug("Setting the expiry interval for client sessions to {} seconds", (Object)maxClientSessionExpiryInterval);
        this.maxClientSessionExpiryInterval.set(maxClientSessionExpiryInterval);
    }

    @Override
    public void setMaxMessageExpiryInterval(long messageExpiryInterval) {
        log.debug("Setting the expiry interval for publish messages to {} seconds", (Object)messageExpiryInterval);
        this.maxMessageExpiryInterval.set(messageExpiryInterval);
    }

    @Override
    public void setRetainedMessagesEnabled(boolean enabled) {
        log.debug("Setting retained messages enabled to {}", (Object)enabled);
        this.retainedMessagesEnabled.set(enabled);
    }

    @Override
    public void setWildcardSubscriptionsEnabled(boolean enabled) {
        log.debug("Setting wildcard subscriptions enabled to {}", (Object)enabled);
        this.wildcardSubscriptionsEnabled.set(enabled);
    }

    @Override
    public void setMaximumQos(@NotNull QoS maximumQos) {
        Preconditions.checkNotNull((Object)((Object)maximumQos), (Object)"Maximum QoS may never be null");
        log.debug("Setting maximum qos to {} ", (Object)maximumQos);
        this.maximumQos.set(maximumQos);
    }

    @Override
    public void setTopicAliasEnabled(boolean enabled) {
        log.debug("Setting topic alias enabled to {}", (Object)enabled);
        this.topicAliasEnabled.set(enabled);
    }

    @Override
    public void setTopicAliasMaxPerClient(int maxPerClient) {
        log.debug("Setting topic alias maximum per client to {}", (Object)maxPerClient);
        this.topicAliasMaxPerClient.set(maxPerClient);
    }

    @Override
    public void setSubscriptionIdentifierEnabled(boolean enabled) {
        log.debug("Setting subscription identifier enabled to {}", (Object)enabled);
        this.subscriptionIdentifierEnabled.set(enabled);
    }

    @Override
    public void setSharedSubscriptionsEnabled(boolean enabled) {
        log.debug("Setting shared subscriptions enabled to {}", (Object)enabled);
        this.sharedSubscriptionsEnabled.set(enabled);
    }

    @Override
    public void setKeepAliveAllowZero(boolean allowZero) {
        log.debug("Setting keep alive allow zero to {}", (Object)allowZero);
        this.keepAliveAllowZero.set(allowZero);
    }

    @Override
    public void setKeepAliveMax(int keepAliveMax) {
        log.debug("Setting keep alive maximum to {} seconds", (Object)keepAliveMax);
        this.keepAliveMax.set(keepAliveMax);
    }

    @Override
    public void setServerReceiveMaximum(int serverReceiveMaximum) {
        log.debug("Setting the server receive maximum to {}", (Object)serverReceiveMaximum);
        this.serverReceiveMaximum.set(serverReceiveMaximum);
    }
}

