/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.diagnostic.data;

import com.hivemq.diagnostic.data.AbstractInformation;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HiveMQSystemInformation
extends AbstractInformation {
    public String getSystemInformation() {
        try {
            OperatingSystemMXBean systemMXBean;
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            StringBuilder systemInformationBuilder = new StringBuilder();
            this.addInformation(systemInformationBuilder, "Available Processors", String.valueOf(operatingSystemMXBean.getAvailableProcessors()));
            this.addInformation(systemInformationBuilder, "System Load Average", String.valueOf(operatingSystemMXBean.getSystemLoadAverage()));
            if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
                systemMXBean = (OperatingSystemMXBean)operatingSystemMXBean;
                this.addInformation(systemInformationBuilder, "Total Swap Space Size", String.valueOf(systemMXBean.getTotalSwapSpaceSize()));
                this.addInformation(systemInformationBuilder, "Committed Virtual Memory Size", String.valueOf(systemMXBean.getCommittedVirtualMemorySize()));
                this.addInformation(systemInformationBuilder, "Total Physical Memory Size", String.valueOf(systemMXBean.getCommittedVirtualMemorySize()));
            }
            if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean) {
                systemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean;
                this.addInformation(systemInformationBuilder, "Max File Descriptor Count", String.valueOf(systemMXBean.getMaxFileDescriptorCount()));
                this.addInformation(systemInformationBuilder, "Open File Descriptor Count", String.valueOf(systemMXBean.getOpenFileDescriptorCount()));
            }
            return systemInformationBuilder.toString();
        }
        catch (Exception e) {
            return "Could not get System Information. Exception: " + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }
}

