/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.diagnostic.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hivemq.diagnostic.data.AbstractInformation;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.lang3.exception.ExceptionUtils;

class NetworkInterfaceInformation
extends AbstractInformation {
    private static final int ADDRESS_LENGTH = 6;

    NetworkInterfaceInformation() {
    }

    public String getNetworkInterfaceInformation() {
        try {
            StringBuilder networkInterfaceBuilder = new StringBuilder();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(interfaces)) {
                this.addInterfaceInformation(networkInterfaceBuilder, netint);
            }
            return networkInterfaceBuilder.toString();
        }
        catch (Exception e) {
            return "Could not determine network interfaces. Exception: " + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private StringBuilder addInterfaceInformation(StringBuilder stringBuilder, NetworkInterface networkInterface) throws SocketException {
        stringBuilder.append(String.format("\u250c[%s]\n", networkInterface.getName()));
        this.addNetworkInformation(stringBuilder, "Display Name", networkInterface.getDisplayName());
        this.addNetworkInformation(stringBuilder, "MAC Address", this.getMacAddress(networkInterface));
        this.addNetworkInformation(stringBuilder, "MTU", this.getMTU(networkInterface));
        this.addNetworkInformation(stringBuilder, "Is Loopback?", this.getIsLoopback(networkInterface));
        this.addNetworkInformation(stringBuilder, "Is P2P?", this.getIsP2P(networkInterface));
        this.addNetworkInformation(stringBuilder, "Is Up?", this.getIsUp(networkInterface));
        this.addNetworkInformation(stringBuilder, "Is Virtual?", this.getIsVirtual(networkInterface));
        this.addNetworkInformation(stringBuilder, "Supports Multicast?", this.getSupportsMulticast(networkInterface));
        stringBuilder.append(String.format("\u2514\u2500[%s]\n", "Inet Addresses"));
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            stringBuilder.append(String.format("\t\u251c\u2500[%s]\n", inetAddress));
        }
        stringBuilder.append("\n");
        return stringBuilder;
    }

    @NotNull
    @VisibleForTesting
    String getIsLoopback(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.isLoopback());
        }
        catch (Exception e) {
            return "Could not determine if interface is loopback interface";
        }
    }

    @NotNull
    @VisibleForTesting
    String getIsP2P(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.isPointToPoint());
        }
        catch (Exception e) {
            return "Could not determine if interface is P2P interface";
        }
    }

    @NotNull
    @VisibleForTesting
    String getIsUp(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.isUp());
        }
        catch (Exception e) {
            return "Could not determine if interface is up";
        }
    }

    @NotNull
    @VisibleForTesting
    String getIsVirtual(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.isVirtual());
        }
        catch (Exception e) {
            return "Could not determine if interface is virtual";
        }
    }

    @NotNull
    @VisibleForTesting
    String getSupportsMulticast(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.supportsMulticast());
        }
        catch (Exception e) {
            return "Could not determine if interface supports multicast";
        }
    }

    @NotNull
    @VisibleForTesting
    String getMTU(@NotNull NetworkInterface networkInterface) {
        try {
            return String.valueOf(networkInterface.getMTU());
        }
        catch (Exception e) {
            return "Could not determine MTU";
        }
    }

    @NotNull
    @VisibleForTesting
    String getMacAddress(@NotNull NetworkInterface networkInterface) {
        try {
            byte[] hardwareAddress = networkInterface.getHardwareAddress();
            if (hardwareAddress != null && hardwareAddress.length == 6) {
                return NetworkInterfaceInformation.formatMACAddress(hardwareAddress);
            }
            return "Could not determine MAC Address";
        }
        catch (Exception e) {
            return "Could not determine MAC Address";
        }
    }

    @VisibleForTesting
    public static String formatMACAddress(byte[] hardwareAddress) {
        Preconditions.checkNotNull((Object)hardwareAddress);
        Preconditions.checkArgument((hardwareAddress.length == 6 ? 1 : 0) != 0, (String)"Hardware address must be of length %s but was %s", (int)6, (int)hardwareAddress.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hardwareAddress.length; ++i) {
            sb.append(String.format("%02X%s", hardwareAddress[i], i < hardwareAddress.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    private StringBuilder addNetworkInformation(StringBuilder infoBuilder, String key, String value) {
        return infoBuilder.append(String.format("\u251c\u2500[%s] = [%s]\n", key, value));
    }
}

