/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.parameter.ExtensionStartInput;
import com.hivemq.extension.sdk.api.parameter.ExtensionStartOutput;
import com.hivemq.extension.sdk.api.parameter.ExtensionStopInput;
import com.hivemq.extension.sdk.api.parameter.ExtensionStopOutput;
import com.hivemq.extensions.ExtensionUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.util.Checkpoints;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class AbstractHiveMQExtension
implements HiveMQExtension {
    @NotNull
    private final String id;
    @NotNull
    private final String version;
    @NotNull
    private final String name;
    @Nullable
    private final String author;
    @NotNull
    private final Path extensionFolderPath;
    private final int priority;
    private final int startPriority;
    @NotNull
    private final AtomicBoolean enabled;
    @Nullable
    private String previousVersion;
    @Nullable
    protected ExtensionMain extensionMain;

    public AbstractHiveMQExtension(@NotNull String id, @NotNull String version, @NotNull String name, @Nullable String author, int priority, int startPriority, @NotNull ExtensionMain extensionMain, boolean enabled, @NotNull Path extensionFolderPath) {
        this.id = id;
        this.version = version;
        this.name = name;
        this.author = author;
        this.extensionFolderPath = extensionFolderPath;
        this.priority = priority;
        this.startPriority = startPriority;
        this.enabled = new AtomicBoolean(enabled);
        this.extensionMain = extensionMain;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Override
    @NotNull
    public Path getExtensionFolderPath() {
        return this.extensionFolderPath;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getStartPriority() {
        return this.startPriority;
    }

    @Override
    @Nullable
    public Class<? extends ExtensionMain> getExtensionMainClazz() {
        return this.extensionMain != null ? this.extensionMain.getClass() : null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setDisabled() {
        this.enabled.set(false);
    }

    @Override
    @Nullable
    public String getPreviousVersion() {
        return this.previousVersion;
    }

    @Override
    public void setPreviousVersion(@Nullable String previousVersion) {
        this.previousVersion = previousVersion;
    }

    @Override
    @Nullable
    public abstract ClassLoader getExtensionClassloader();

    @NotNull
    public abstract Logger getLogger();

    @Override
    public void start(@NotNull ExtensionStartInput extensionStartInput, @NotNull ExtensionStartOutput extensionStartOutput) {
        if (this.extensionMain != null) {
            this.extensionMain.extensionStart(extensionStartInput, extensionStartOutput);
        }
    }

    @Override
    public void stop(@NotNull ExtensionStopInput extensionStopInput, @NotNull ExtensionStopOutput extensionStopOutput) {
        if (this.extensionMain != null) {
            this.extensionMain.extensionStop(extensionStopInput, extensionStopOutput);
        }
    }

    @Override
    public void clean(boolean disable) {
        this.extensionMain = null;
        if (disable) {
            try {
                boolean disabled;
                if (this.extensionFolderPath.toFile().exists()) {
                    disabled = ExtensionUtil.disableExtensionFolder(this.extensionFolderPath);
                } else {
                    this.getLogger().trace("Extension folder {} was already removed and cannot be disabled, continuing normally", (Object)this.extensionFolderPath.toFile().getAbsolutePath());
                    disabled = true;
                }
                if (!disabled) {
                    this.getLogger().warn("Could not disable extension folder {}.", (Object)this.extensionFolderPath);
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Could not disable extension folder {}, reason {}", (Object)this.extensionFolderPath, (Object)e.getMessage());
                this.getLogger().trace("Original exception", (Throwable)e);
            }
            Checkpoints.checkpoint("extension-disabled");
        }
    }
}

