/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.parameter.EnhancedAuthConnectInput;
import com.hivemq.extension.sdk.api.auth.parameter.SimpleAuthInput;
import com.hivemq.extension.sdk.api.packets.connect.ConnectPacket;
import com.hivemq.extensions.packets.connect.ConnectPacketImpl;
import com.hivemq.extensions.parameter.ClientBasedInputImpl;
import com.hivemq.mqtt.message.connect.CONNECT;
import io.netty.channel.Channel;
import java.util.Objects;
import java.util.function.Supplier;

public class AuthConnectInput
extends ClientBasedInputImpl
implements SimpleAuthInput,
EnhancedAuthConnectInput,
Supplier<AuthConnectInput> {
    @NotNull
    private final CONNECT connect;
    @Nullable
    private ConnectPacketImpl connectPacket;
    private final long connectTimestamp;

    public AuthConnectInput(@NotNull CONNECT connect, @NotNull Channel channel) {
        super(connect.getClientIdentifier(), channel);
        this.connect = connect;
        this.connectTimestamp = Objects.requireNonNullElse(ClientConnectionContext.of(channel).getConnectReceivedTimestamp(), System.currentTimeMillis());
    }

    @NotNull
    public ConnectPacket getConnectPacket() {
        if (this.connectPacket == null) {
            this.connectPacket = new ConnectPacketImpl(this.connect, this.connectTimestamp);
        }
        return this.connectPacket;
    }

    @Override
    @NotNull
    public AuthConnectInput get() {
        return this;
    }
}

