/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.auth.AuthOutput;
import com.hivemq.extensions.auth.AuthenticationState;
import com.hivemq.extensions.executor.task.AbstractAsyncOutput;
import com.hivemq.extensions.executor.task.AbstractSimpleAsyncOutput;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.mqtt.handler.auth.MqttAuthSender;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5AuthReasonCode;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AuthContext<T extends AuthOutput<?>>
extends PluginInOutTaskContext<T>
implements Supplier<T> {
    private static final Logger log = LoggerFactory.getLogger(AuthContext.class);
    @NotNull
    final ChannelHandlerContext ctx;
    @NotNull
    final MqttAuthSender authSender;
    private final int authenticatorsCount;
    private int counter;
    @NotNull
    private AuthenticationState state = AuthenticationState.UNDECIDED;
    @NotNull
    T output;

    AuthContext(@NotNull String identifier, @NotNull ChannelHandlerContext ctx, @NotNull MqttAuthSender authSender, int authenticatorsCount, @NotNull T output) {
        super(identifier);
        this.ctx = ctx;
        this.authSender = authSender;
        this.authenticatorsCount = authenticatorsCount;
        this.output = output;
    }

    @Override
    public void pluginPost(@NotNull T output) {
        if (((AbstractSimpleAsyncOutput)output).isTimedOut()) {
            switch (((AbstractAsyncOutput)output).getTimeoutFallback()) {
                case FAILURE: {
                    ((AuthOutput)output).failByTimeout();
                    break;
                }
                case SUCCESS: {
                    ((AuthOutput)output).nextByTimeout();
                }
            }
        } else if (((AuthOutput)output).getAuthenticationState() == AuthenticationState.UNDECIDED && ((AuthOutput)output).isAuthenticatorPresent()) {
            ((AuthOutput)output).failByUndecided();
        }
        if (!this.state.isFinal() && ((AuthOutput)output).getAuthenticationState() != AuthenticationState.UNDECIDED) {
            this.state = ((AuthOutput)output).getAuthenticationState();
        }
        if (++this.counter < this.authenticatorsCount) {
            if (!this.state.isFinal()) {
                this.output = this.createNextOutput(output);
            }
        } else {
            this.finishExtensionFlow(output);
        }
    }

    @NotNull
    abstract T createNextOutput(@NotNull T var1);

    @Override
    @NotNull
    public T get() {
        return this.output;
    }

    private void finishExtensionFlow(@NotNull T output) {
        block3: {
            if (!this.ctx.channel().isActive()) {
                return;
            }
            try {
                this.ctx.executor().execute(() -> {
                    switch (this.state) {
                        case CONTINUE: {
                            this.continueAuthentication(output);
                            break;
                        }
                        case SUCCESS: {
                            this.succeedAuthentication(output);
                            break;
                        }
                        case FAILED: 
                        case NEXT_EXTENSION_OR_DEFAULT: {
                            this.failAuthentication(output);
                            break;
                        }
                        case UNDECIDED: {
                            assert (!output.isAuthenticatorPresent());
                            this.undecidedAuthentication(output);
                        }
                    }
                });
            }
            catch (RejectedExecutionException ex) {
                if (this.ctx.executor().isShutdown()) break block3;
                ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(this.ctx.channel());
                log.error("Execution of authentication was rejected for client with IP {}.", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"), (Object)ex);
            }
        }
    }

    private void continueAuthentication(@NotNull T output) {
        ChannelFuture authFuture = this.authSender.sendAuth(this.ctx.channel(), ((AuthOutput)output).getAuthenticationData(), Mqtt5AuthReasonCode.CONTINUE_AUTHENTICATION, Mqtt5UserProperties.of(((AuthOutput)output).getOutboundUserProperties().asInternalList()), ((AuthOutput)output).getReasonString());
        authFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                io.netty.util.concurrent.ScheduledFuture timeoutFuture = this.ctx.executor().schedule(this::onTimeout, (long)output.getTimeout(), TimeUnit.SECONDS);
                ClientConnectionContext.of(this.ctx.channel()).setAuthFuture((ScheduledFuture<?>)timeoutFuture);
            } else if (future.channel().isActive()) {
                this.onSendException(future.cause());
            }
        }));
    }

    void succeedAuthentication(@NotNull T output) {
        ClientConnectionContext.of(this.ctx.channel()).setAuthPermissions(((AuthOutput)output).getDefaultPermissions());
    }

    abstract void failAuthentication(@NotNull T var1);

    abstract void undecidedAuthentication(@NotNull T var1);

    abstract void onTimeout();

    abstract void onSendException(@NotNull Throwable var1);
}

