/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.auth.parameter.EnhancedAuthOutput;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.packets.connect.ConnackReasonCode;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extensions.auth.AuthOutput;
import com.hivemq.extensions.auth.parameter.ModifiableClientSettingsImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import java.nio.ByteBuffer;
import java.time.Duration;

public class ConnectAuthOutput
extends AuthOutput<EnhancedAuthOutput>
implements EnhancedAuthOutput {
    @NotNull
    private Mqtt5ConnAckReasonCode reasonCode = Mqtt5ConnAckReasonCode.NOT_AUTHORIZED;
    @NotNull
    private Mqtt5ConnAckReasonCode timeoutReasonCode = Mqtt5ConnAckReasonCode.NOT_AUTHORIZED;
    @Nullable
    private Boolean clearPasswordAfterAuth;
    private final boolean supportsEnhancedAuth;

    public ConnectAuthOutput(@NotNull PluginOutPutAsyncer asyncer, boolean validateUTF8, @NotNull ModifiableDefaultPermissions defaultPermissions, @NotNull ModifiableClientSettingsImpl clientSettings, int timeout, boolean supportsEnhancedAuth) {
        super(asyncer, validateUTF8, defaultPermissions, clientSettings, timeout);
        this.supportsEnhancedAuth = supportsEnhancedAuth;
        this.setDefaultReasonStrings();
    }

    ConnectAuthOutput(@NotNull ConnectAuthOutput prevOutput) {
        super(prevOutput);
        this.supportsEnhancedAuth = prevOutput.supportsEnhancedAuth;
        this.setDefaultReasonStrings();
    }

    private void setDefaultReasonStrings() {
        this.reasonString = "Authentication failed";
        this.timeoutReasonString = "Authentication failed, authenticator timed out";
    }

    public void authenticateSuccessfully(boolean clearPasswordAfterAuth) {
        this.clearPasswordAfterAuth = clearPasswordAfterAuth;
        super.authenticateSuccessfully();
    }

    @Override
    public void authenticateSuccessfully(@NotNull ByteBuffer authenticationData) {
        this.checkEnhancedAuthSupport();
        super.authenticateSuccessfully(authenticationData);
    }

    @Override
    public void authenticateSuccessfully(@NotNull byte[] authenticationData) {
        this.checkEnhancedAuthSupport();
        super.authenticateSuccessfully(authenticationData);
    }

    @Override
    public void continueAuthentication() {
        this.checkEnhancedAuthSupport();
        super.continueAuthentication();
    }

    private void checkEnhancedAuthSupport() {
        if (!this.supportsEnhancedAuth) {
            throw new UnsupportedOperationException("Continue authentication is not supported as the client does not support enhanced authentication.");
        }
    }

    public void failAuthentication(@NotNull ConnackReasonCode reasonCode) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication();
        this.reasonCode = connAckReasonCode;
    }

    public void failAuthentication(@NotNull ConnackReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication(reasonString);
        this.reasonCode = connAckReasonCode;
    }

    public void failAuthentication(@NotNull DisconnectedReasonCode reasonCode) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication();
        this.reasonCode = connAckReasonCode;
    }

    public void failAuthentication(@NotNull DisconnectedReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication(reasonString);
        this.reasonCode = connAckReasonCode;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull ConnackReasonCode reasonCode) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback);
        this.timeoutReasonCode = connAckReasonCode;
        return async;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull ConnackReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback, reasonString);
        this.timeoutReasonCode = connAckReasonCode;
        return async;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull DisconnectedReasonCode reasonCode) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback);
        this.timeoutReasonCode = connAckReasonCode;
        return async;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull DisconnectedReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5ConnAckReasonCode connAckReasonCode = ConnectAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback, reasonString);
        this.timeoutReasonCode = connAckReasonCode;
        return async;
    }

    @Override
    void failByTimeout() {
        super.failByTimeout();
        this.reasonCode = this.timeoutReasonCode;
    }

    @Override
    void failByUndecided() {
        super.failByUndecided();
        this.reasonCode = Mqtt5ConnAckReasonCode.NOT_AUTHORIZED;
        this.reasonString = "Authentication failed, authenticator did not decide authenticity";
    }

    @Override
    void failByThrowable(@NotNull Throwable throwable) {
        super.failByThrowable(throwable);
        this.reasonCode = Mqtt5ConnAckReasonCode.UNSPECIFIED_ERROR;
        this.reasonString = "Authentication failed, exception in authenticator";
    }

    @NotNull
    Mqtt5ConnAckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @Nullable
    public Boolean isClearPasswordAfterAuth() {
        return this.clearPasswordAfterAuth;
    }

    @NotNull
    private static Mqtt5ConnAckReasonCode checkReasonCode(@NotNull ConnackReasonCode reasonCode) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"CONNACK reason code must never be null");
        Preconditions.checkArgument((reasonCode != ConnackReasonCode.SUCCESS ? 1 : 0) != 0, (Object)"CONNACK reason code must not be SUCCESS for failed authentication");
        return Mqtt5ConnAckReasonCode.from(reasonCode);
    }

    @NotNull
    private static Mqtt5ConnAckReasonCode checkReasonCode(@NotNull DisconnectedReasonCode disconnectedReasonCode) {
        Preconditions.checkNotNull((Object)disconnectedReasonCode, (Object)"Disconnected reason code must never be null");
        Mqtt5ConnAckReasonCode connackReasonCode = Mqtt5ConnAckReasonCode.from(disconnectedReasonCode);
        Preconditions.checkArgument((connackReasonCode != null ? 1 : 0) != 0, (Object)("The disconnected reason code " + disconnectedReasonCode.name() + " is not a CONNACK reason code and therefore must not be used during connect authentication."));
        return connackReasonCode;
    }
}

