/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.auth.parameter.ModifiableClientSettings;
import com.hivemq.extension.sdk.api.auth.parameter.SimpleAuthOutput;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.packets.connect.ConnackReasonCode;
import com.hivemq.extension.sdk.api.packets.general.ModifiableUserProperties;
import com.hivemq.extensions.auth.ConnectAuthOutput;
import java.time.Duration;

class ConnectSimpleAuthOutput
implements SimpleAuthOutput {
    @NotNull
    private final ConnectAuthOutput delegate;

    ConnectSimpleAuthOutput(@NotNull ConnectAuthOutput delegate) {
        this.delegate = delegate;
    }

    public void authenticateSuccessfully() {
        this.delegate.authenticateSuccessfully();
    }

    public void authenticateSuccessfully(boolean clearPasswordAfterAuth) {
        this.delegate.authenticateSuccessfully(clearPasswordAfterAuth);
    }

    public void failAuthentication() {
        this.delegate.failAuthentication();
    }

    public void failAuthentication(@NotNull ConnackReasonCode reasonCode) {
        this.delegate.failAuthentication(reasonCode);
    }

    public void failAuthentication(@Nullable String reasonString) {
        this.delegate.failAuthentication(reasonString);
    }

    public void failAuthentication(@NotNull ConnackReasonCode reasonCode, @Nullable String reasonString) {
        this.delegate.failAuthentication(reasonCode, reasonString);
    }

    public void nextExtensionOrDefault() {
        this.delegate.nextExtensionOrDefault();
    }

    @NotNull
    public ModifiableUserProperties getOutboundUserProperties() {
        return this.delegate.getOutboundUserProperties();
    }

    @NotNull
    public ModifiableDefaultPermissions getDefaultPermissions() {
        return this.delegate.getDefaultPermissions();
    }

    @NotNull
    public ModifiableClientSettings getClientSettings() {
        return this.delegate.getClientSettings();
    }

    @NotNull
    public Async<SimpleAuthOutput> async(@NotNull Duration timeout) {
        return new AsyncWrapper<SimpleAuthOutput>(this.delegate.async(timeout), this);
    }

    @NotNull
    public Async<SimpleAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback) {
        return new AsyncWrapper<SimpleAuthOutput>(this.delegate.async(timeout, fallback), this);
    }

    @NotNull
    public Async<SimpleAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull ConnackReasonCode reasonCode) {
        return new AsyncWrapper<SimpleAuthOutput>(this.delegate.async(timeout, fallback, reasonCode), this);
    }

    @NotNull
    public Async<SimpleAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @Nullable String reasonString) {
        return new AsyncWrapper<SimpleAuthOutput>(this.delegate.async(timeout, fallback, reasonString), this);
    }

    @NotNull
    public Async<SimpleAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull ConnackReasonCode reasonCode, @Nullable String reasonString) {
        return new AsyncWrapper<SimpleAuthOutput>(this.delegate.async(timeout, fallback, reasonCode, reasonString), this);
    }

    private static class AsyncWrapper<T>
    implements Async<T> {
        @NotNull
        private final Async<?> delegate;
        @NotNull
        private final T output;

        public AsyncWrapper(@NotNull Async<?> delegate, @NotNull T output) {
            this.delegate = delegate;
            this.output = output;
        }

        public void resume() {
            this.delegate.resume();
        }

        @NotNull
        public T getOutput() {
            return this.output;
        }

        @NotNull
        public Async.Status getStatus() {
            return this.delegate.getStatus();
        }
    }
}

