/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.auth.parameter.PublishAuthorizerInput;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.packets.publish.PublishPacket;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.extensions.packets.publish.WillPublishPacketImpl;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.publish.PUBLISH;
import io.netty.channel.Channel;
import java.util.Objects;
import java.util.function.Supplier;

public class PublishAuthorizerInputImpl
implements PublishAuthorizerInput,
PluginTaskInput,
Supplier<PublishAuthorizerInputImpl> {
    @NotNull
    private final PublishPacket publishPacket;
    @NotNull
    private final ConnectionInformation connectionInformation;
    @NotNull
    private final ClientInformation clientInformation;

    public PublishAuthorizerInputImpl(@NotNull PUBLISH publish, @NotNull Channel channel, @NotNull String clientId) {
        Preconditions.checkNotNull((Object)publish, (Object)"publish must never be null");
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId must never be null");
        this.publishPacket = new PublishPacketImpl(publish);
        this.clientInformation = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        this.connectionInformation = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
    }

    public PublishAuthorizerInputImpl(@NotNull MqttWillPublish publish, @NotNull Channel channel, @NotNull String clientId) {
        Preconditions.checkNotNull((Object)publish, (Object)"publish must never be null");
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        Preconditions.checkNotNull((Object)clientId, (Object)"clientId must never be null");
        Long timestamp = Objects.requireNonNullElse(ClientConnectionContext.of(channel).getConnectReceivedTimestamp(), System.currentTimeMillis());
        this.publishPacket = new WillPublishPacketImpl(publish, timestamp);
        this.clientInformation = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        this.connectionInformation = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
    }

    @NotNull
    public PublishPacket getPublishPacket() {
        return this.publishPacket;
    }

    @NotNull
    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    @NotNull
    public ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    @Override
    @NotNull
    public PublishAuthorizerInputImpl get() {
        return this;
    }
}

