/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.interceptor.Interceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.disconnect.DisconnectOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingreq.PingReqInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pingresp.PingRespOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.puback.PubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubcomp.PubcompOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.publish.PublishOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrec.PubrecOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.pubrel.PubrelOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.suback.SubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.subscribe.SubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsuback.UnsubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsubscribe.UnsubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class ClientContextImpl {
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ModifiableDefaultPermissions defaultPermissions;
    @NotNull
    private volatile ImmutableList<PublishInboundInterceptor> publishInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PublishOutboundInterceptor> publishOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubackInboundInterceptor> pubackInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubackOutboundInterceptor> pubackOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubrecInboundInterceptor> pubrecInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubrecOutboundInterceptor> pubrecOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubrelInboundInterceptor> pubrelInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubrelOutboundInterceptor> pubrelOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubcompInboundInterceptor> pubcompInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PubcompOutboundInterceptor> pubcompOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<SubscribeInboundInterceptor> subscribeInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<SubackOutboundInterceptor> subackOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<UnsubscribeInboundInterceptor> unsubscribeInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<UnsubackOutboundInterceptor> unsubackOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<DisconnectInboundInterceptor> disconnectInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<DisconnectOutboundInterceptor> disconnectOutbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PingReqInboundInterceptor> pingReqInbounds = ImmutableList.of();
    @NotNull
    private volatile ImmutableList<PingRespOutboundInterceptor> pingRespOutbounds = ImmutableList.of();

    public ClientContextImpl(@NotNull HiveMQExtensions hiveMQExtensions, @NotNull ModifiableDefaultPermissions defaultPermissions) {
        this.hiveMQExtensions = hiveMQExtensions;
        this.defaultPermissions = defaultPermissions;
    }

    public synchronized void addPublishInboundInterceptor(@NotNull PublishInboundInterceptor interceptor) {
        this.publishInbounds = this.addInterceptor(this.publishInbounds, interceptor);
    }

    public synchronized void addPublishOutboundInterceptor(@NotNull PublishOutboundInterceptor interceptor) {
        this.publishOutbounds = this.addInterceptor(this.publishOutbounds, interceptor);
    }

    public synchronized void addPubackInboundInterceptor(@NotNull PubackInboundInterceptor interceptor) {
        this.pubackInbounds = this.addInterceptor(this.pubackInbounds, interceptor);
    }

    public synchronized void addPubackOutboundInterceptor(@NotNull PubackOutboundInterceptor interceptor) {
        this.pubackOutbounds = this.addInterceptor(this.pubackOutbounds, interceptor);
    }

    public synchronized void addPubrecInboundInterceptor(@NotNull PubrecInboundInterceptor interceptor) {
        this.pubrecInbounds = this.addInterceptor(this.pubrecInbounds, interceptor);
    }

    public synchronized void addPubrecOutboundInterceptor(@NotNull PubrecOutboundInterceptor interceptor) {
        this.pubrecOutbounds = this.addInterceptor(this.pubrecOutbounds, interceptor);
    }

    public synchronized void addPubrelInboundInterceptor(@NotNull PubrelInboundInterceptor interceptor) {
        this.pubrelInbounds = this.addInterceptor(this.pubrelInbounds, interceptor);
    }

    public synchronized void addPubrelOutboundInterceptor(@NotNull PubrelOutboundInterceptor interceptor) {
        this.pubrelOutbounds = this.addInterceptor(this.pubrelOutbounds, interceptor);
    }

    public synchronized void addPubcompInboundInterceptor(@NotNull PubcompInboundInterceptor interceptor) {
        this.pubcompInbounds = this.addInterceptor(this.pubcompInbounds, interceptor);
    }

    public synchronized void addPubcompOutboundInterceptor(@NotNull PubcompOutboundInterceptor interceptor) {
        this.pubcompOutbounds = this.addInterceptor(this.pubcompOutbounds, interceptor);
    }

    public synchronized void addSubscribeInboundInterceptor(@NotNull SubscribeInboundInterceptor interceptor) {
        this.subscribeInbounds = this.addInterceptor(this.subscribeInbounds, interceptor);
    }

    public synchronized void addSubackOutboundInterceptor(@NotNull SubackOutboundInterceptor interceptor) {
        this.subackOutbounds = this.addInterceptor(this.subackOutbounds, interceptor);
    }

    public synchronized void addUnsubscribeInboundInterceptor(@NotNull UnsubscribeInboundInterceptor interceptor) {
        this.unsubscribeInbounds = this.addInterceptor(this.unsubscribeInbounds, interceptor);
    }

    public synchronized void addUnsubackOutboundInterceptor(@NotNull UnsubackOutboundInterceptor interceptor) {
        this.unsubackOutbounds = this.addInterceptor(this.unsubackOutbounds, interceptor);
    }

    public synchronized void addDisconnectInboundInterceptor(@NotNull DisconnectInboundInterceptor interceptor) {
        this.disconnectInbounds = this.addInterceptor(this.disconnectInbounds, interceptor);
    }

    public synchronized void addDisconnectOutboundInterceptor(@NotNull DisconnectOutboundInterceptor interceptor) {
        this.disconnectOutbounds = this.addInterceptor(this.disconnectOutbounds, interceptor);
    }

    public synchronized void addPingReqInboundInterceptor(@NotNull PingReqInboundInterceptor interceptor) {
        this.pingReqInbounds = this.addInterceptor(this.pingReqInbounds, interceptor);
    }

    public synchronized void addPingRespOutboundInterceptor(@NotNull PingRespOutboundInterceptor interceptor) {
        this.pingRespOutbounds = this.addInterceptor(this.pingRespOutbounds, interceptor);
    }

    public synchronized void removePublishInboundInterceptor(@NotNull PublishInboundInterceptor interceptor) {
        this.publishInbounds = this.removeInterceptor(this.publishInbounds, interceptor);
    }

    public synchronized void removePublishOutboundInterceptor(@NotNull PublishOutboundInterceptor interceptor) {
        this.publishOutbounds = this.removeInterceptor(this.publishOutbounds, interceptor);
    }

    public synchronized void removePubackInboundInterceptor(@NotNull PubackInboundInterceptor interceptor) {
        this.pubackInbounds = this.removeInterceptor(this.pubackInbounds, interceptor);
    }

    public synchronized void removePubackOutboundInterceptor(@NotNull PubackOutboundInterceptor interceptor) {
        this.pubackOutbounds = this.removeInterceptor(this.pubackOutbounds, interceptor);
    }

    public synchronized void removePubrecInboundInterceptor(@NotNull PubrecInboundInterceptor interceptor) {
        this.pubrecInbounds = this.removeInterceptor(this.pubrecInbounds, interceptor);
    }

    public synchronized void removePubrecOutboundInterceptor(@NotNull PubrecOutboundInterceptor interceptor) {
        this.pubrecOutbounds = this.removeInterceptor(this.pubrecOutbounds, interceptor);
    }

    public synchronized void removePubrelInboundInterceptor(@NotNull PubrelInboundInterceptor interceptor) {
        this.pubrelInbounds = this.removeInterceptor(this.pubrelInbounds, interceptor);
    }

    public synchronized void removePubrelOutboundInterceptor(@NotNull PubrelOutboundInterceptor interceptor) {
        this.pubrelOutbounds = this.removeInterceptor(this.pubrelOutbounds, interceptor);
    }

    public synchronized void removePubcompInboundInterceptor(@NotNull PubcompInboundInterceptor interceptor) {
        this.pubcompInbounds = this.removeInterceptor(this.pubcompInbounds, interceptor);
    }

    public synchronized void removePubcompOutboundInterceptor(@NotNull PubcompOutboundInterceptor interceptor) {
        this.pubcompOutbounds = this.removeInterceptor(this.pubcompOutbounds, interceptor);
    }

    public synchronized void removeSubscribeInboundInterceptor(@NotNull SubscribeInboundInterceptor interceptor) {
        this.subscribeInbounds = this.removeInterceptor(this.subscribeInbounds, interceptor);
    }

    public synchronized void removeSubackOutboundInterceptor(@NotNull SubackOutboundInterceptor interceptor) {
        this.subackOutbounds = this.removeInterceptor(this.subackOutbounds, interceptor);
    }

    public synchronized void removeUnsubscribeInboundInterceptor(@NotNull UnsubscribeInboundInterceptor interceptor) {
        this.unsubscribeInbounds = this.removeInterceptor(this.unsubscribeInbounds, interceptor);
    }

    public synchronized void removeUnsubackOutboundInterceptor(@NotNull UnsubackOutboundInterceptor interceptor) {
        this.unsubackOutbounds = this.removeInterceptor(this.unsubackOutbounds, interceptor);
    }

    public synchronized void removeDisconnectInboundInterceptor(@NotNull DisconnectInboundInterceptor interceptor) {
        this.disconnectInbounds = this.removeInterceptor(this.disconnectInbounds, interceptor);
    }

    public synchronized void removeDisconnectOutboundInterceptor(@NotNull DisconnectOutboundInterceptor interceptor) {
        this.disconnectOutbounds = this.removeInterceptor(this.disconnectOutbounds, interceptor);
    }

    public synchronized void removePingReqInboundInterceptor(@NotNull PingReqInboundInterceptor interceptor) {
        this.pingReqInbounds = this.removeInterceptor(this.pingReqInbounds, interceptor);
    }

    public synchronized void removePingRespOutboundInterceptor(@NotNull PingRespOutboundInterceptor interceptor) {
        this.pingRespOutbounds = this.removeInterceptor(this.pingRespOutbounds, interceptor);
    }

    @NotNull
    public @NotNull List<@NotNull Interceptor> getAllInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return (List)this.streamAllInterceptors().filter(interceptor -> interceptor.getClass().getClassLoader().equals(extensionClassLoader)).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    public @NotNull List<@NotNull Interceptor> getAllInterceptors() {
        return (List)this.streamAllInterceptors().sorted(Comparator.comparingInt(this::getExtensionPriority).reversed()).collect(ImmutableList.toImmutableList());
    }

    @NotNull
    private Stream<Interceptor> streamAllInterceptors() {
        return Streams.concat((Stream[])new Stream[]{this.publishInbounds.stream(), this.publishOutbounds.stream(), this.pubackInbounds.stream(), this.pubackOutbounds.stream(), this.pubrecInbounds.stream(), this.pubrecOutbounds.stream(), this.pubrelInbounds.stream(), this.pubrelOutbounds.stream(), this.pubcompInbounds.stream(), this.pubcompOutbounds.stream(), this.subscribeInbounds.stream(), this.subackOutbounds.stream(), this.unsubscribeInbounds.stream(), this.unsubackOutbounds.stream(), this.disconnectInbounds.stream(), this.disconnectOutbounds.stream(), this.pingReqInbounds.stream(), this.pingRespOutbounds.stream()});
    }

    @NotNull
    public @NotNull List<@NotNull PublishInboundInterceptor> getPublishInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.publishInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PublishInboundInterceptor> getPublishInboundInterceptors() {
        return this.publishInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PublishOutboundInterceptor> getPublishOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.publishOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PublishOutboundInterceptor> getPublishOutboundInterceptors() {
        return this.publishOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubackInboundInterceptor> getPubackInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubackInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubackInboundInterceptor> getPubackInboundInterceptors() {
        return this.pubackInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubackOutboundInterceptor> getPubackOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubackOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubackOutboundInterceptor> getPubackOutboundInterceptors() {
        return this.pubackOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubrecInboundInterceptor> getPubrecInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubrecInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrecInboundInterceptor> getPubrecInboundInterceptors() {
        return this.pubrecInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubrecOutboundInterceptor> getPubrecOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubrecOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrecOutboundInterceptor> getPubrecOutboundInterceptors() {
        return this.pubrecOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubrelInboundInterceptor> getPubrelInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubrelInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrelInboundInterceptor> getPubrelInboundInterceptors() {
        return this.pubrelInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubrelOutboundInterceptor> getPubrelOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubrelOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubrelOutboundInterceptor> getPubrelOutboundInterceptors() {
        return this.pubrelOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubcompInboundInterceptor> getPubcompInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubcompInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubcompInboundInterceptor> getPubcompInboundInterceptors() {
        return this.pubcompInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PubcompOutboundInterceptor> getPubcompOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pubcompOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PubcompOutboundInterceptor> getPubcompOutboundInterceptors() {
        return this.pubcompOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull SubscribeInboundInterceptor> getSubscribeInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.subscribeInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull SubscribeInboundInterceptor> getSubscribeInboundInterceptors() {
        return this.subscribeInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull SubackOutboundInterceptor> getSubackOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.subackOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull SubackOutboundInterceptor> getSubackOutboundInterceptors() {
        return this.subackOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull UnsubscribeInboundInterceptor> getUnsubscribeInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.unsubscribeInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull UnsubscribeInboundInterceptor> getUnsubscribeInboundInterceptors() {
        return this.unsubscribeInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull UnsubackOutboundInterceptor> getUnsubackOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.unsubackOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull UnsubackOutboundInterceptor> getUnsubackOutboundInterceptors() {
        return this.unsubackOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectInboundInterceptor> getDisconnectInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.disconnectInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectInboundInterceptor> getDisconnectInboundInterceptors() {
        return this.disconnectInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectOutboundInterceptor> getDisconnectOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.disconnectOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull DisconnectOutboundInterceptor> getDisconnectOutboundInterceptors() {
        return this.disconnectOutbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PingReqInboundInterceptor> getPingReqInboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pingReqInbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PingReqInboundInterceptor> getPingReqInboundInterceptors() {
        return this.pingReqInbounds;
    }

    @NotNull
    public @NotNull List<@NotNull PingRespOutboundInterceptor> getPingRespOutboundInterceptorsOfExtension(@NotNull ClassLoader extensionClassLoader) {
        return this.filterInterceptorsOfExtension(this.pingRespOutbounds, extensionClassLoader);
    }

    @NotNull
    public @NotNull List<@NotNull PingRespOutboundInterceptor> getPingRespOutboundInterceptors() {
        return this.pingRespOutbounds;
    }

    @NotNull
    public ModifiableDefaultPermissions getDefaultPermissions() {
        return this.defaultPermissions;
    }

    @NotNull
    private <T extends Interceptor> ImmutableList<T> addInterceptor(@NotNull ImmutableList<T> interceptors, @NotNull T interceptor) {
        int i;
        if (interceptors.isEmpty()) {
            return ImmutableList.of(interceptor);
        }
        int priority = this.getExtensionPriority(interceptor);
        int low = 0;
        int high = interceptors.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Interceptor midInterceptor = (Interceptor)interceptors.get(mid);
            int midPriority = this.getExtensionPriority(midInterceptor);
            if (midPriority >= priority) {
                if (midPriority == priority && midInterceptor == interceptor) {
                    return interceptors;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(interceptors.size() + 1));
        for (i = 0; i < low; ++i) {
            builder.add((Object)((Interceptor)interceptors.get(i)));
        }
        builder.add(interceptor);
        for (i = low; i < interceptors.size(); ++i) {
            builder.add((Object)((Interceptor)interceptors.get(i)));
        }
        return builder.build();
    }

    @NotNull
    private <T extends Interceptor> ImmutableList<T> removeInterceptor(@NotNull ImmutableList<T> interceptors, @NotNull T interceptor) {
        if (interceptors.isEmpty()) {
            return interceptors;
        }
        if (interceptors.size() == 1 && interceptors.get(0) == interceptor) {
            return ImmutableList.of();
        }
        int priority = this.getExtensionPriority(interceptor);
        int low = 0;
        int high = interceptors.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Interceptor midInterceptor = (Interceptor)interceptors.get(mid);
            int midPriority = this.getExtensionPriority(midInterceptor);
            if (midPriority >= priority) {
                if (midPriority == priority && midInterceptor == interceptor) {
                    int i;
                    ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(interceptors.size() - 1));
                    for (i = 0; i < mid; ++i) {
                        builder.add((Object)((Interceptor)interceptors.get(i)));
                    }
                    for (i = mid + 1; i < interceptors.size(); ++i) {
                        builder.add((Object)((Interceptor)interceptors.get(i)));
                    }
                    return builder.build();
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return interceptors;
    }

    @NotNull
    private <T extends Interceptor> ImmutableList<T> filterInterceptorsOfExtension(@NotNull ImmutableList<T> interceptors, @NotNull ClassLoader extensionClassloader) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < interceptors.size(); ++i) {
            Interceptor interceptor = (Interceptor)interceptors.get(i);
            if (!interceptor.getClass().getClassLoader().equals(extensionClassloader)) continue;
            builder.add((Object)interceptor);
        }
        return builder.build();
    }

    @NotNull
    private <T extends Interceptor> ImmutableList<T> removeInterceptorsOfExtension(@NotNull ImmutableList<T> interceptors, @NotNull ClassLoader extensionClassloader) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < interceptors.size(); ++i) {
            Interceptor interceptor = (Interceptor)interceptors.get(i);
            if (interceptor.getClass().getClassLoader().equals(extensionClassloader)) continue;
            builder.add((Object)interceptor);
        }
        return builder.build();
    }

    private int getExtensionPriority(@NotNull Object object) {
        HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(object.getClass().getClassLoader());
        if (extension != null) {
            return extension.getPriority();
        }
        return -1;
    }
}

