/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientTlsInformation;
import com.hivemq.extension.sdk.api.client.parameter.TlsInformation;
import java.security.cert.X509Certificate;
import java.util.Optional;

public class ClientTlsInformationImpl
implements ClientTlsInformation,
TlsInformation {
    @Nullable
    private final X509Certificate certificate;
    private final X509Certificate @Nullable [] certificateChain;
    @NotNull
    private final String cipherSuite;
    @NotNull
    private final String protocol;
    @Nullable
    private final String hostname;

    public ClientTlsInformationImpl(@Nullable X509Certificate certificate, X509Certificate @Nullable [] certificateChain, @NotNull String cipherSuite, @NotNull String protocol, @Nullable String hostname) {
        Preconditions.checkNotNull((Object)cipherSuite, (Object)"cipher suite must never be null");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol must never be null");
        this.certificate = certificate;
        this.certificateChain = certificateChain;
        this.cipherSuite = cipherSuite;
        this.protocol = protocol;
        this.hostname = hostname;
    }

    @NotNull
    public X509Certificate getCertificate() {
        Preconditions.checkNotNull((Object)this.certificate, (Object)"certificate must never be null");
        return this.certificate;
    }

    @NotNull
    public X509Certificate[] getCertificateChain() {
        Preconditions.checkNotNull((Object)this.certificateChain, (Object)"certificate chain must never be null");
        return this.certificateChain;
    }

    @NotNull
    public Optional<X509Certificate> getClientCertificate() {
        return Optional.ofNullable(this.certificate);
    }

    @NotNull
    public Optional<X509Certificate[]> getClientCertificateChain() {
        return Optional.ofNullable(this.certificateChain);
    }

    @NotNull
    public String getCipherSuite() {
        return this.cipherSuite;
    }

    @NotNull
    public String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public Optional<String> getHostname() {
        return Optional.ofNullable(this.hostname);
    }
}

