/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionAttributeStore;
import com.hivemq.extensions.client.parameter.ConnectionAttributes;
import com.hivemq.util.Bytes;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public class ConnectionAttributeStoreImpl
implements ConnectionAttributeStore {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private final Channel channel;

    public ConnectionAttributeStoreImpl(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must not be null");
        this.channel = channel;
    }

    public void put(@NotNull String key, @NotNull ByteBuffer value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)value, (Object)"Value of connection attribute must not be null.");
        ConnectionAttributes.getInstance(this.channel).put(key, value);
    }

    public void putAsString(@NotNull String key, @NotNull String value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)value, (Object)"Value of connection attribute must not be null.");
        this.putAsString(key, value, DEFAULT_CHARSET);
    }

    public void putAsString(@NotNull String key, @NotNull String value, @NotNull Charset charset) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)value, (Object)"Value of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)charset, (Object)"Charset of connection attribute must not be null.");
        this.put(key, ByteBuffer.wrap(value.getBytes(charset)));
    }

    @NotNull
    public Optional<ByteBuffer> get(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        ConnectionAttributes connectionAttributes = ConnectionAttributes.getInstanceIfPresent(this.channel);
        if (connectionAttributes == null) {
            return Optional.empty();
        }
        return connectionAttributes.get(key);
    }

    @NotNull
    public Optional<String> getAsString(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        return this.getAsString(key, DEFAULT_CHARSET);
    }

    @NotNull
    public Optional<String> getAsString(@NotNull String key, @NotNull Charset charset) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)charset, (Object)"Charset of connection attribute must not be null.");
        byte[] bytes = Bytes.getBytesFromReadOnlyBuffer(this.get(key));
        if (bytes == null) {
            return Optional.empty();
        }
        return Optional.of(new String(bytes, charset));
    }

    @NotNull
    public Optional<Map<String, ByteBuffer>> getAll() {
        ConnectionAttributes connectionAttributes = ConnectionAttributes.getInstanceIfPresent(this.channel);
        if (connectionAttributes == null) {
            return Optional.empty();
        }
        return connectionAttributes.getAll();
    }

    @NotNull
    public Optional<ByteBuffer> remove(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        ConnectionAttributes connectionAttributes = ConnectionAttributes.getInstanceIfPresent(this.channel);
        if (connectionAttributes == null) {
            return Optional.empty();
        }
        return connectionAttributes.remove(key);
    }

    public void clear() {
        ConnectionAttributes connectionAttributes = ConnectionAttributes.getInstanceIfPresent(this.channel);
        if (connectionAttributes != null) {
            connectionAttributes.clear();
        }
    }
}

