/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.client.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.services.exception.LimitExceededException;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ThreadSafe
public class ConnectionAttributes {
    @Nullable
    private Map<String, ByteBuffer> data;
    private final int maxValueSizeBytes;

    @Nullable
    static ConnectionAttributes getInstanceIfPresent(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel for connection attributes must not be null.");
        return ClientConnectionContext.of(channel).getConnectionAttributes();
    }

    @NotNull
    public static ConnectionAttributes getInstance(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"Channel for connection attributes must not be null.");
        ConnectionAttributes connectionAttributes = ConnectionAttributes.getInstanceIfPresent(channel);
        if (connectionAttributes != null) {
            return connectionAttributes;
        }
        int maxValueSizeBytes = 10240;
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        return clientConnectionContext.setConnectionAttributesIfAbsent(new ConnectionAttributes(10240));
    }

    @VisibleForTesting
    ConnectionAttributes(int maxValueSizeBytes) {
        this.maxValueSizeBytes = maxValueSizeBytes;
    }

    public synchronized void put(@NotNull String key, @NotNull ByteBuffer value) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        Preconditions.checkNotNull((Object)value, (Object)"Value of connection attribute must not be null.");
        if (value.remaining() > this.maxValueSizeBytes) {
            throw new LimitExceededException("value with a size of " + value.remaining() + " bytes for key '" + key + "' in connection attribute store is larger than the allowed limit of " + this.maxValueSizeBytes + " bytes");
        }
        if (this.data == null) {
            this.data = new HashMap<String, ByteBuffer>(4);
        }
        this.data.put(key, value.duplicate().asReadOnlyBuffer());
    }

    @NotNull
    public synchronized Optional<ByteBuffer> get(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        if (this.data == null) {
            return Optional.empty();
        }
        ByteBuffer value = this.data.get(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value.asReadOnlyBuffer());
    }

    @NotNull
    public synchronized Optional<Map<String, ByteBuffer>> getAll() {
        if (this.data == null) {
            return Optional.empty();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<String, ByteBuffer> entry : this.data.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().asReadOnlyBuffer());
        }
        return Optional.of(builder.build());
    }

    @NotNull
    public synchronized Optional<ByteBuffer> remove(@NotNull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key of connection attribute must not be null.");
        if (this.data == null) {
            return Optional.empty();
        }
        ByteBuffer value = this.data.remove(key);
        if (this.data.isEmpty()) {
            this.data = null;
        }
        return Optional.ofNullable(value);
    }

    public synchronized void clear() {
        this.data = null;
    }
}

