/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.config;

import com.hivemq.configuration.service.exception.ValidationError;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.HiveMQExtensionEntity;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HiveMQExtensionXMLReader {
    private static final Logger log = LoggerFactory.getLogger(HiveMQExtensionXMLReader.class);

    @NotNull
    public static Optional<HiveMQExtensionEntity> getExtensionEntityFromXML(@NotNull Path extensionFolder, boolean logging) {
        Path extensionXMLPath = extensionFolder.resolve("hivemq-extension.xml");
        if (Files.exists(extensionXMLPath, new LinkOption[0]) && logging) {
            log.trace("Found hivemq-extension.xml {}", (Object)extensionXMLPath);
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{HiveMQExtensionEntity.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            HiveMQExtensionEntity unmarshal = (HiveMQExtensionEntity)unmarshaller.unmarshal(extensionXMLPath.toFile());
            Optional<ValidationError> validationError = HiveMQExtensionXMLReader.validateHiveMQExtensionEntity(unmarshal);
            if (validationError.isPresent()) {
                if (logging) {
                    log.warn("Could not parse \"{}\" in {} because of {}. Not loading extension.", new Object[]{"hivemq-extension.xml", extensionFolder.toString(), validationError.get().getMessage()});
                }
                return Optional.empty();
            }
            return Optional.of(unmarshal);
        }
        catch (JAXBException e) {
            if (logging) {
                log.warn("Could not parse \"{}\" in {}. Not loading extension.", new Object[]{"hivemq-extension.xml", extensionFolder.toString(), e});
            }
            return Optional.empty();
        }
    }

    @NotNull
    private static Optional<ValidationError> validateHiveMQExtensionEntity(@Nullable HiveMQExtensionEntity hiveMQExtensionEntity) {
        String message = "missing %s";
        if (hiveMQExtensionEntity == null || hiveMQExtensionEntity.getId().isEmpty()) {
            return Optional.of(new ValidationError("missing %s", "<id>"));
        }
        if (hiveMQExtensionEntity.getName().isEmpty()) {
            return Optional.of(new ValidationError("missing %s", "<name>"));
        }
        if (hiveMQExtensionEntity.getVersion().isEmpty()) {
            return Optional.of(new ValidationError("missing %s", "<version>"));
        }
        return Optional.empty();
    }
}

