/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor;

import com.google.common.base.Preconditions;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.executor.task.PluginInTask;
import com.hivemq.extensions.executor.task.PluginInTaskContext;
import com.hivemq.extensions.executor.task.PluginOutTask;
import com.hivemq.extensions.executor.task.PluginOutTaskContext;
import com.hivemq.extensions.executor.task.PluginTaskContext;
import com.hivemq.extensions.executor.task.PluginTaskExecution;
import com.hivemq.extensions.executor.task.PluginTaskExecutor;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import com.hivemq.persistence.local.xodus.bucket.BucketUtils;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class PluginTaskExecutorServiceImpl
implements PluginTaskExecutorService {
    @NotNull
    private final PluginTaskExecutor[] taskExecutors;
    private final int taskExecutorCount = InternalConfigurations.EXTENSION_TASK_QUEUE_EXECUTOR_THREADS_COUNT.get();

    @Inject
    public PluginTaskExecutorServiceImpl(@NotNull Provider<PluginTaskExecutor> taskExecutorProvider, @NotNull ShutdownHooks shutdownHooks) {
        this.taskExecutors = new PluginTaskExecutor[this.taskExecutorCount];
        for (int i = 0; i < this.taskExecutorCount; ++i) {
            this.taskExecutors[i] = (PluginTaskExecutor)taskExecutorProvider.get();
        }
        shutdownHooks.add(new PluginTaskExecutorServiceShutdownHook(this.taskExecutors));
    }

    @Override
    public <I extends PluginTaskInput> void handlePluginInTaskExecution(@NotNull PluginInTaskContext pluginInTaskContext, @NotNull Supplier<I> pluginInputSupplier, @NotNull PluginInTask<I> pluginTask) {
        PluginTaskExecutor taskExecutor = this.getPluginTaskExecutor(pluginInTaskContext);
        Preconditions.checkNotNull((Object)pluginInTaskContext, (Object)"Extension context cannot be null");
        Preconditions.checkNotNull(pluginInputSupplier, (Object)"Input supplier cannot be null");
        Preconditions.checkNotNull(pluginTask, (Object)"Extension task cannot be null");
        taskExecutor.handlePluginTaskExecution(new PluginTaskExecution(pluginInTaskContext, pluginInputSupplier, null, pluginTask));
    }

    @Override
    public <O extends PluginTaskOutput> void handlePluginOutTaskExecution(@NotNull PluginOutTaskContext<O> pluginOutTaskContext, @NotNull Supplier<O> pluginOutputSupplier, @NotNull PluginOutTask<O> pluginTask) {
        Preconditions.checkNotNull(pluginOutTaskContext, (Object)"Extension context cannot be null");
        Preconditions.checkNotNull(pluginOutputSupplier, (Object)"Output supplier cannot be null");
        Preconditions.checkNotNull(pluginTask, (Object)"Extension task cannot be null");
        PluginTaskExecutor taskExecutor = this.getPluginTaskExecutor(pluginOutTaskContext);
        taskExecutor.handlePluginTaskExecution(new PluginTaskExecution(pluginOutTaskContext, null, pluginOutputSupplier, pluginTask));
    }

    @Override
    public <I extends PluginTaskInput, O extends PluginTaskOutput> void handlePluginInOutTaskExecution(@NotNull PluginInOutTaskContext<O> pluginInOutContext, @NotNull Supplier<I> pluginInputSupplier, @NotNull Supplier<O> pluginOutputSupplier, @NotNull PluginInOutTask<I, O> pluginTask) {
        Preconditions.checkNotNull(pluginInOutContext, (Object)"Extension context cannot be null");
        Preconditions.checkNotNull(pluginInputSupplier, (Object)"Input supplier cannot be null");
        Preconditions.checkNotNull(pluginOutputSupplier, (Object)"Output supplier cannot be null");
        Preconditions.checkNotNull(pluginTask, (Object)"Extension task cannot be null");
        PluginTaskExecutor taskExecutor = this.getPluginTaskExecutor(pluginInOutContext);
        taskExecutor.handlePluginTaskExecution(new PluginTaskExecution<I, O>(pluginInOutContext, pluginInputSupplier, pluginOutputSupplier, pluginTask));
    }

    @NotNull
    private PluginTaskExecutor getPluginTaskExecutor(@NotNull PluginTaskContext pluginTaskContext) {
        int bucket = BucketUtils.getBucket(pluginTaskContext.getIdentifier(), this.taskExecutorCount);
        return this.taskExecutors[bucket];
    }

    private static class PluginTaskExecutorServiceShutdownHook
    implements HiveMQShutdownHook {
        @NotNull
        private final PluginTaskExecutor[] taskExecutors;

        PluginTaskExecutorServiceShutdownHook(@NotNull PluginTaskExecutor[] taskExecutors) {
            this.taskExecutors = taskExecutors;
        }

        @Override
        @NotNull
        public String name() {
            return "Plugin Task Executor Service Shutdown Hook";
        }

        @Override
        public void run() {
            for (PluginTaskExecutor taskExecutor : this.taskExecutors) {
                taskExecutor.stop();
            }
        }
    }
}

