/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor.task;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.SimpleAsyncOutput;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbstractSimpleAsyncOutput<T>
implements PluginTaskOutput,
SimpleAsyncOutput<T> {
    @NotNull
    protected final PluginOutPutAsyncer asyncer;
    @NotNull
    private final AtomicBoolean async = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean called = new AtomicBoolean(false);
    @NotNull
    private final AtomicBoolean timedOut = new AtomicBoolean(false);
    @NotNull
    private final SettableFuture<Boolean> asyncFuture = SettableFuture.create();

    public AbstractSimpleAsyncOutput(@NotNull PluginOutPutAsyncer asyncer) {
        this.asyncer = asyncer;
    }

    @NotNull
    public Async<T> async(@NotNull Duration timeout) {
        Preconditions.checkNotNull((Object)timeout, (Object)"Timeout duration must never be null");
        this.checkCalled();
        return this.asyncer.asyncify(this, timeout);
    }

    private void checkCalled() {
        if (!this.called.compareAndSet(false, true)) {
            throw new UnsupportedOperationException("async must not be called more than once");
        }
    }

    @Override
    public boolean isAsync() {
        return this.async.get();
    }

    @Override
    public void markAsAsync() {
        this.async.set(true);
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut.get();
    }

    @Override
    public void markAsTimedOut() {
        this.timedOut.set(true);
    }

    @Override
    public void resetAsyncStatus() {
        this.timedOut.set(false);
        this.async.set(false);
        this.called.set(false);
    }

    @Override
    @NotNull
    public SettableFuture<Boolean> getAsyncFuture() {
        return this.asyncFuture;
    }

    @Override
    @NotNull
    public TimeoutFallback getTimeoutFallback() {
        return TimeoutFallback.FAILURE;
    }
}

