/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.events.client.ClientLifecycleEventListener;
import com.hivemq.extension.sdk.api.events.client.ClientLifecycleEventListenerProvider;
import com.hivemq.extension.sdk.api.events.client.parameters.AuthenticationFailedInput;
import com.hivemq.extension.sdk.api.events.client.parameters.AuthenticationSuccessfulInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ClientInitiatedDisconnectInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ClientLifecycleEventListenerProviderInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ConnectionLostInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ConnectionStartInput;
import com.hivemq.extension.sdk.api.events.client.parameters.ServerInitiatedDisconnectInput;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.events.LifecycleEventListeners;
import com.hivemq.extensions.events.OnAuthFailedEvent;
import com.hivemq.extensions.events.OnAuthSuccessEvent;
import com.hivemq.extensions.events.OnClientDisconnectEvent;
import com.hivemq.extensions.events.OnServerDisconnectEvent;
import com.hivemq.extensions.events.client.parameters.AuthenticationFailedInputImpl;
import com.hivemq.extensions.events.client.parameters.AuthenticationSuccessfulInputImpl;
import com.hivemq.extensions.events.client.parameters.ClientEventListeners;
import com.hivemq.extensions.events.client.parameters.ClientInitiatedDisconnectInputImpl;
import com.hivemq.extensions.events.client.parameters.ClientLifecycleEventListenerProviderInputImpl;
import com.hivemq.extensions.events.client.parameters.ConnectionStartInputImpl;
import com.hivemq.extensions.events.client.parameters.ServerInitiatedDisconnectInputImpl;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInTask;
import com.hivemq.extensions.executor.task.PluginInTaskContext;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLifecycleEventHandler
extends SimpleChannelInboundHandler<CONNECT> {
    private static final Logger log = LoggerFactory.getLogger(ClientLifecycleEventHandler.class);
    @NotNull
    private final LifecycleEventListeners lifecycleEventListeners;
    @NotNull
    private final PluginTaskExecutorService pluginTaskExecutorService;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @VisibleForTesting
    @Nullable
    ClientLifecycleEventListenerProviderInput providerInput;

    @Inject
    public ClientLifecycleEventHandler(@NotNull LifecycleEventListeners lifecycleEventListeners, @NotNull PluginTaskExecutorService pluginTaskExecutorService, @NotNull HiveMQExtensions hiveMQExtensions) {
        this.lifecycleEventListeners = lifecycleEventListeners;
        this.pluginTaskExecutorService = pluginTaskExecutorService;
        this.hiveMQExtensions = hiveMQExtensions;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull CONNECT connect) {
        try {
            this.fireOnMqttConnect(ctx, connect);
        }
        catch (Exception e) {
            log.debug("Firing OnMqttConnectEvent failed: ", (Throwable)e);
        }
        ctx.fireChannelRead((Object)connect);
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) throws Exception {
        Preconditions.checkNotNull((Object)evt, (Object)"A user event must never be null");
        if (evt instanceof OnAuthSuccessEvent) {
            try {
                this.fireOnAuthSuccess(ctx);
            }
            catch (Exception e) {
                log.debug("Firing OnAuthSuccessEvent failed: ", (Throwable)e);
            }
        } else if (evt instanceof OnAuthFailedEvent) {
            try {
                this.fireOnAuthFailed(ctx, (OnAuthFailedEvent)evt);
            }
            catch (Exception e) {
                log.debug("Firing OnAuthFailedEvent failed: ", (Throwable)e);
            }
        } else if (evt instanceof OnClientDisconnectEvent) {
            try {
                this.fireOnClientDisconnect(ctx, (OnClientDisconnectEvent)evt);
            }
            catch (Exception e) {
                log.debug("Firing OnClientDisconnectEvent failed: ", (Throwable)e);
            }
        } else if (evt instanceof OnServerDisconnectEvent) {
            try {
                this.fireOnServerDisconnect(ctx, (OnServerDisconnectEvent)evt);
            }
            catch (Exception e) {
                log.debug("Firing OnServerDisconnectEvent failed: ", (Throwable)e);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void fireOnServerDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull OnServerDisconnectEvent disconnectEvent) {
        String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
        if (clientId == null) {
            return;
        }
        Map<String, ClientLifecycleEventListenerProvider> pluginEventListenerProviderMap = this.lifecycleEventListeners.getClientLifecycleEventListenerProviderMap();
        if (pluginEventListenerProviderMap.isEmpty()) {
            return;
        }
        ClientEventListeners eventListeners = this.getClientEventListeners(ctx);
        if (this.providerInput == null) {
            this.providerInput = new ClientLifecycleEventListenerProviderInputImpl(clientId, ctx.channel());
        }
        ProviderInTaskContext taskContext = new ProviderInTaskContext(clientId);
        ServerInitiatedDisconnectInputImpl disconnectInput = new ServerInitiatedDisconnectInputImpl(clientId, ctx.channel(), disconnectEvent.getReasonCode(), disconnectEvent.getReasonString(), disconnectEvent.getUserProperties());
        for (Map.Entry<String, ClientLifecycleEventListenerProvider> eventListenerEntry : pluginEventListenerProviderMap.entrySet()) {
            EventTask authFailedTask = new EventTask(eventListenerEntry.getValue(), this.providerInput, eventListenerEntry.getKey(), eventListeners);
            this.pluginTaskExecutorService.handlePluginInTaskExecution(taskContext, disconnectInput, authFailedTask);
        }
    }

    private void fireOnClientDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull OnClientDisconnectEvent disconnectEvent) {
        String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
        if (clientId == null) {
            return;
        }
        Map<String, ClientLifecycleEventListenerProvider> pluginEventListenerProviderMap = this.lifecycleEventListeners.getClientLifecycleEventListenerProviderMap();
        if (pluginEventListenerProviderMap.isEmpty()) {
            return;
        }
        ClientEventListeners eventListeners = this.getClientEventListeners(ctx);
        if (this.providerInput == null) {
            this.providerInput = new ClientLifecycleEventListenerProviderInputImpl(clientId, ctx.channel());
        }
        ProviderInTaskContext taskContext = new ProviderInTaskContext(clientId);
        ClientInitiatedDisconnectInputImpl disconnectInput = new ClientInitiatedDisconnectInputImpl(clientId, ctx.channel(), disconnectEvent.getReasonCode(), disconnectEvent.getReasonString(), disconnectEvent.getUserProperties(), disconnectEvent.isGraceful());
        for (Map.Entry<String, ClientLifecycleEventListenerProvider> eventListenerEntry : pluginEventListenerProviderMap.entrySet()) {
            EventTask authFailedTask = new EventTask(eventListenerEntry.getValue(), this.providerInput, eventListenerEntry.getKey(), eventListeners);
            this.pluginTaskExecutorService.handlePluginInTaskExecution(taskContext, disconnectInput, authFailedTask);
        }
    }

    private void fireOnAuthFailed(@NotNull ChannelHandlerContext ctx, @NotNull OnAuthFailedEvent authFailedEvent) {
        String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
        if (clientId == null) {
            return;
        }
        Map<String, ClientLifecycleEventListenerProvider> pluginEventListenerProviderMap = this.lifecycleEventListeners.getClientLifecycleEventListenerProviderMap();
        if (pluginEventListenerProviderMap.isEmpty()) {
            return;
        }
        ClientEventListeners eventListeners = this.getClientEventListeners(ctx);
        if (this.providerInput == null) {
            this.providerInput = new ClientLifecycleEventListenerProviderInputImpl(clientId, ctx.channel());
        }
        ProviderInTaskContext taskContext = new ProviderInTaskContext(clientId);
        AuthenticationFailedInputImpl failedInput = new AuthenticationFailedInputImpl(ctx.channel(), clientId, authFailedEvent.getReasonCode(), authFailedEvent.getReasonString(), authFailedEvent.getUserProperties());
        for (Map.Entry<String, ClientLifecycleEventListenerProvider> eventListenerEntry : pluginEventListenerProviderMap.entrySet()) {
            EventTask authFailedTask = new EventTask(eventListenerEntry.getValue(), this.providerInput, eventListenerEntry.getKey(), eventListeners);
            this.pluginTaskExecutorService.handlePluginInTaskExecution(taskContext, failedInput, authFailedTask);
        }
    }

    private void fireOnAuthSuccess(@NotNull ChannelHandlerContext ctx) {
        String clientId = ClientConnectionContext.of(ctx.channel()).getClientId();
        if (clientId == null) {
            return;
        }
        Map<String, ClientLifecycleEventListenerProvider> pluginEventListenerProviderMap = this.lifecycleEventListeners.getClientLifecycleEventListenerProviderMap();
        if (pluginEventListenerProviderMap.isEmpty()) {
            return;
        }
        ClientEventListeners eventListeners = this.getClientEventListeners(ctx);
        if (this.providerInput == null) {
            this.providerInput = new ClientLifecycleEventListenerProviderInputImpl(clientId, ctx.channel());
        }
        ProviderInTaskContext taskContext = new ProviderInTaskContext(clientId);
        AuthenticationSuccessfulInputImpl input = new AuthenticationSuccessfulInputImpl(clientId, ctx.channel());
        for (Map.Entry<String, ClientLifecycleEventListenerProvider> eventListenerEntry : pluginEventListenerProviderMap.entrySet()) {
            EventTask authSuccessTask = new EventTask(eventListenerEntry.getValue(), this.providerInput, eventListenerEntry.getKey(), eventListeners);
            this.pluginTaskExecutorService.handlePluginInTaskExecution(taskContext, input, authSuccessTask);
        }
    }

    private void fireOnMqttConnect(@NotNull ChannelHandlerContext ctx, @NotNull CONNECT connect) {
        Map<String, ClientLifecycleEventListenerProvider> pluginEventListenerProviderMap = this.lifecycleEventListeners.getClientLifecycleEventListenerProviderMap();
        if (pluginEventListenerProviderMap.isEmpty()) {
            return;
        }
        ClientEventListeners eventListeners = this.getClientEventListeners(ctx);
        if (this.providerInput == null) {
            this.providerInput = new ClientLifecycleEventListenerProviderInputImpl(connect.getClientIdentifier(), ctx.channel());
        }
        ProviderInTaskContext taskContext = new ProviderInTaskContext(connect.getClientIdentifier());
        ConnectionStartInputImpl connectionStartInput = new ConnectionStartInputImpl(connect, ctx.channel());
        for (Map.Entry<String, ClientLifecycleEventListenerProvider> eventListenerEntry : pluginEventListenerProviderMap.entrySet()) {
            EventTask connectEventTask = new EventTask(eventListenerEntry.getValue(), this.providerInput, eventListenerEntry.getKey(), eventListeners);
            this.pluginTaskExecutorService.handlePluginInTaskExecution(taskContext, connectionStartInput, connectEventTask);
        }
    }

    @NotNull
    private ClientEventListeners getClientEventListeners(@NotNull ChannelHandlerContext ctx) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        if (clientConnectionContext.getExtensionClientEventListeners() == null) {
            clientConnectionContext.setExtensionClientEventListeners(new ClientEventListeners(this.hiveMQExtensions));
        }
        return clientConnectionContext.getExtensionClientEventListeners();
    }

    private static class EventTask<T extends PluginTaskInput>
    implements PluginInTask<T> {
        @NotNull
        private final ClientLifecycleEventListenerProvider eventListenerProvider;
        @NotNull
        private final ClientLifecycleEventListenerProviderInput eventListenerProviderInput;
        @NotNull
        private final String pluginId;
        @NotNull
        private final ClientEventListeners eventListeners;

        EventTask(@NotNull ClientLifecycleEventListenerProvider eventListenerProvider, @NotNull ClientLifecycleEventListenerProviderInput eventListenerProviderInput, @NotNull String pluginId, @NotNull ClientEventListeners eventListeners) {
            this.eventListenerProvider = eventListenerProvider;
            this.eventListenerProviderInput = eventListenerProviderInput;
            this.pluginId = pluginId;
            this.eventListeners = eventListeners;
        }

        @Override
        public void accept(@NotNull T pluginTaskInput) {
            ClientLifecycleEventListener eventListener = this.updateAndGetEventListener();
            if (eventListener == null) {
                return;
            }
            try {
                if (pluginTaskInput instanceof ConnectionStartInputImpl) {
                    eventListener.onMqttConnectionStart((ConnectionStartInput)((ConnectionStartInputImpl)pluginTaskInput));
                } else if (pluginTaskInput instanceof AuthenticationSuccessfulInputImpl) {
                    eventListener.onAuthenticationSuccessful((AuthenticationSuccessfulInput)((AuthenticationSuccessfulInputImpl)pluginTaskInput));
                } else if (pluginTaskInput instanceof AuthenticationFailedInputImpl) {
                    eventListener.onAuthenticationFailedDisconnect((AuthenticationFailedInput)((AuthenticationFailedInputImpl)pluginTaskInput));
                } else if (pluginTaskInput instanceof ClientInitiatedDisconnectInputImpl) {
                    ClientInitiatedDisconnectInputImpl taskInput = (ClientInitiatedDisconnectInputImpl)pluginTaskInput;
                    if (taskInput.isGraceful()) {
                        eventListener.onClientInitiatedDisconnect((ClientInitiatedDisconnectInput)taskInput);
                    } else {
                        eventListener.onConnectionLost((ConnectionLostInput)taskInput);
                    }
                } else if (pluginTaskInput instanceof ServerInitiatedDisconnectInputImpl) {
                    eventListener.onServerInitiatedDisconnect((ServerInitiatedDisconnectInput)((ServerInitiatedDisconnectInputImpl)pluginTaskInput));
                }
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on a client lifecycle event. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)e);
                Exceptions.rethrowError(e);
            }
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.eventListenerProvider.getClass().getClassLoader();
        }

        @Nullable
        private ClientLifecycleEventListener updateAndGetEventListener() {
            boolean contains = false;
            ClientLifecycleEventListener eventListener = null;
            for (Map.Entry<String, ClientLifecycleEventListener> pluginEventListenerEntry : this.eventListeners.getPluginEventListenersMap().entrySet()) {
                String id = pluginEventListenerEntry.getKey();
                ClientLifecycleEventListener listener = pluginEventListenerEntry.getValue();
                if (!listener.getClass().getClassLoader().equals(this.eventListenerProvider.getClass().getClassLoader()) || !id.equals(this.pluginId)) continue;
                contains = true;
                eventListener = listener;
            }
            if (!contains) {
                try {
                    eventListener = this.eventListenerProvider.getClientLifecycleEventListener(this.eventListenerProviderInput);
                    if (eventListener != null) {
                        this.eventListeners.put(this.pluginId, eventListener);
                    }
                }
                catch (Throwable t) {
                    log.warn("Uncaught exception was thrown from extension with id \"{}\" in client lifecycle event listener provider. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)t);
                    Exceptions.rethrowError(t);
                }
            }
            return eventListener;
        }
    }

    private static class ProviderInTaskContext
    extends PluginInTaskContext {
        ProviderInTaskContext(@NotNull String identifier) {
            super(identifier);
        }
    }
}

