/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.collect.ImmutableMap;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extension.sdk.api.interceptor.connack.ConnackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.connack.ConnackOutboundInterceptorProvider;
import com.hivemq.extension.sdk.api.interceptor.connack.parameter.ConnackOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.connack.parameter.ConnackOutboundOutput;
import com.hivemq.extension.sdk.api.interceptor.connack.parameter.ConnackOutboundProviderInput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.connack.parameter.ConnackOutboundInputImpl;
import com.hivemq.extensions.interceptor.connack.parameter.ConnackOutboundOutputImpl;
import com.hivemq.extensions.interceptor.connack.parameter.ConnackOutboundProviderInputImpl;
import com.hivemq.extensions.packets.connack.ConnackPacketImpl;
import com.hivemq.extensions.packets.connack.ModifiableConnackPacketImpl;
import com.hivemq.extensions.services.interceptor.Interceptors;
import com.hivemq.logging.EventLog;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnackOutboundInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnackOutboundInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;
    @NotNull
    private final Interceptors interceptors;
    @NotNull
    private final ServerInformation serverInformation;
    @NotNull
    private final EventLog eventLog;

    @Inject
    public ConnackOutboundInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService, @NotNull Interceptors interceptors, @NotNull ServerInformation serverInformation, @NotNull EventLog eventLog) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
        this.interceptors = interceptors;
        this.serverInformation = serverInformation;
        this.eventLog = eventLog;
    }

    public void handleOutboundConnack(@NotNull ChannelHandlerContext ctx, @NotNull CONNACK connack, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        String clientId = clientConnectionContext.getClientId();
        if (clientId == null) {
            ctx.write((Object)connack, promise);
            return;
        }
        ImmutableMap<String, ConnackOutboundInterceptorProvider> providers = this.interceptors.connackOutboundInterceptorProviders();
        if (providers.isEmpty()) {
            ctx.write((Object)connack, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        boolean requestResponseInformation = clientConnectionContext.isRequestResponseInformation();
        ConnackOutboundProviderInputImpl providerInput = new ConnackOutboundProviderInputImpl(this.serverInformation, clientInfo, connectionInfo);
        ConnackPacketImpl packet = new ConnackPacketImpl(connack);
        ConnackOutboundInputImpl input = new ConnackOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<ConnackOutboundInputImpl> inputHolder = new ExtensionParameterHolder<ConnackOutboundInputImpl>(input);
        ModifiableConnackPacketImpl modifiablePacket = new ModifiableConnackPacketImpl(packet, this.configurationService, requestResponseInformation);
        ConnackOutboundOutputImpl output = new ConnackOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<ConnackOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<ConnackOutboundOutputImpl>(output);
        ConnackInterceptorContext context = new ConnackInterceptorContext(clientId, providers.size(), ctx, promise, inputHolder, outputHolder);
        for (Map.Entry entry : providers.entrySet()) {
            ConnackOutboundInterceptorProvider provider = (ConnackOutboundInterceptorProvider)entry.getValue();
            HiveMQExtension extension = this.hiveMQExtensions.getExtension((String)entry.getKey());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            ConnackInterceptorTask task = new ConnackInterceptorTask(provider, providerInput, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class ConnackInterceptorTask
    implements PluginInOutTask<ConnackOutboundInputImpl, ConnackOutboundOutputImpl> {
        @NotNull
        private final ConnackOutboundInterceptorProvider provider;
        @NotNull
        private final ConnackOutboundProviderInputImpl providerInput;
        @NotNull
        private final String extensionId;

        private ConnackInterceptorTask(@NotNull ConnackOutboundInterceptorProvider provider, @NotNull ConnackOutboundProviderInputImpl providerInput, @NotNull String extensionId) {
            this.provider = provider;
            this.providerInput = providerInput;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public ConnackOutboundOutputImpl apply(@NotNull ConnackOutboundInputImpl input, @NotNull ConnackOutboundOutputImpl output) {
            if (output.isPrevent()) {
                return output;
            }
            try {
                ConnackOutboundInterceptor interceptor = this.provider.getConnackOutboundInterceptor((ConnackOutboundProviderInput)this.providerInput);
                if (interceptor != null) {
                    interceptor.onOutboundConnack((ConnackOutboundInput)input, (ConnackOutboundOutput)output);
                }
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound CONNACK interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.prevent();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.provider.getClass().getClassLoader();
        }
    }

    private class ConnackInterceptorContext
    extends PluginInOutTaskContext<ConnackOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<ConnackOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<ConnackOutboundOutputImpl> outputHolder;

        ConnackInterceptorContext(String clientId, @NotNull int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<ConnackOutboundInputImpl> inputHolder, ExtensionParameterHolder<ConnackOutboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull ConnackOutboundOutputImpl output) {
            if (output.isPrevent()) {
                this.finishInterceptor();
            } else if (output.isTimedOut() && output.getTimeoutFallback() == TimeoutFallback.FAILURE) {
                output.prevent();
                this.finishInterceptor();
            } else {
                if (output.getConnackPacket().isModified()) {
                    this.inputHolder.set(this.inputHolder.get().update(output));
                }
                if (!this.finishInterceptor()) {
                    this.outputHolder.set(output.update(this.inputHolder.get()));
                }
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            if (this.outputHolder.get().isPrevent()) {
                ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(this.ctx.channel());
                clientConnectionContext.proposeClientState(ClientState.DISCONNECTING);
                ConnackOutboundInterceptorHandler.this.eventLog.clientWasDisconnected(this.ctx.channel(), "Connection prevented by extension in CONNACK outbound interceptor");
                clientConnectionContext.proposeClientState(ClientState.DISCONNECTED_BY_SERVER);
                this.ctx.channel().close();
            } else {
                this.ctx.writeAndFlush((Object)CONNACK.from(this.inputHolder.get().getConnackPacket()), this.promise);
            }
        }
    }
}

