/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.subscribe.SubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.subscribe.parameter.SubscribeInboundInput;
import com.hivemq.extension.sdk.api.interceptor.subscribe.parameter.SubscribeInboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.handler.PluginAuthorizerService;
import com.hivemq.extensions.interceptor.subscribe.parameter.SubscribeInboundInputImpl;
import com.hivemq.extensions.interceptor.subscribe.parameter.SubscribeInboundOutputImpl;
import com.hivemq.extensions.packets.subscribe.ModifiableSubscribePacketImpl;
import com.hivemq.extensions.packets.subscribe.SubscribePacketImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IncomingSubscribeHandler {
    private static final Logger log = LoggerFactory.getLogger(IncomingSubscribeHandler.class);
    @NotNull
    private final PluginTaskExecutorService executorService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginAuthorizerService authorizerService;
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    public IncomingSubscribeHandler(@NotNull PluginTaskExecutorService executorService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginAuthorizerService authorizerService, @NotNull FullConfigurationService configurationService, @NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.executorService = executorService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.authorizerService = authorizerService;
        this.configurationService = configurationService;
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void interceptOrDelegate(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE subscribe) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            this.authorizerService.authorizeSubscriptions(ctx, subscribe);
            return;
        }
        List<SubscribeInboundInterceptor> interceptors = clientContext.getSubscribeInboundInterceptors();
        if (interceptors.isEmpty()) {
            this.authorizerService.authorizeSubscriptions(ctx, subscribe);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        SubscribePacketImpl packet = new SubscribePacketImpl(subscribe);
        SubscribeInboundInputImpl input = new SubscribeInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<SubscribeInboundInputImpl> inputHolder = new ExtensionParameterHolder<SubscribeInboundInputImpl>(input);
        ModifiableSubscribePacketImpl modifiablePacket = new ModifiableSubscribePacketImpl(packet, this.configurationService);
        SubscribeInboundOutputImpl output = new SubscribeInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<SubscribeInboundOutputImpl> outputHolder = new ExtensionParameterHolder<SubscribeInboundOutputImpl>(output);
        SubscribeInboundInterceptorContext context = new SubscribeInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (SubscribeInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            SubscribeInboundInterceptorTask task = new SubscribeInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class SubscribeInboundInterceptorTask
    implements PluginInOutTask<SubscribeInboundInputImpl, SubscribeInboundOutputImpl> {
        @NotNull
        private final SubscribeInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        private SubscribeInboundInterceptorTask(@NotNull SubscribeInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public SubscribeInboundOutputImpl apply(@NotNull SubscribeInboundInputImpl input, @NotNull SubscribeInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                return output;
            }
            try {
                this.interceptor.onInboundSubscribe((SubscribeInboundInput)input, (SubscribeInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound SUBSCRIBE interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.forciblyPreventSubscribeDelivery();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private class SubscribeInboundInterceptorContext
    extends PluginInOutTaskContext<SubscribeInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<SubscribeInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<SubscribeInboundOutputImpl> outputHolder;

        SubscribeInboundInterceptorContext(String clientId, @NotNull int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<SubscribeInboundInputImpl> inputHolder, ExtensionParameterHolder<SubscribeInboundOutputImpl> outputHolder) {
            super(clientId);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull SubscribeInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                this.finishInterceptor();
            } else if (output.isTimedOut() && output.getTimeoutFallback() == TimeoutFallback.FAILURE) {
                output.forciblyPreventSubscribeDelivery();
                this.finishInterceptor();
            } else {
                if (output.getSubscribePacket().isModified()) {
                    this.inputHolder.set(this.inputHolder.get().update(output));
                }
                if (!this.finishInterceptor()) {
                    this.outputHolder.set(output.update(this.inputHolder.get()));
                }
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            SubscribeInboundOutputImpl output = this.outputHolder.get();
            if (output.isPreventDelivery()) {
                this.prevent(output);
            } else {
                SUBSCRIBE finalSubscribe = SUBSCRIBE.from(this.inputHolder.get().getSubscribePacket());
                IncomingSubscribeHandler.this.authorizerService.authorizeSubscriptions(this.ctx, finalSubscribe);
            }
        }

        private void prevent(@NotNull SubscribeInboundOutputImpl output) {
            int size = output.getSubscribePacket().getSubscriptions().size();
            ProtocolVersion version = ClientConnection.of(this.ctx.channel()).getProtocolVersion();
            ArrayList<Mqtt5SubAckReasonCode> reasonCodesBuilder = new ArrayList<Mqtt5SubAckReasonCode>(size);
            if (version == ProtocolVersion.MQTTv3_1) {
                IncomingSubscribeHandler.this.mqttServerDisconnector.disconnect(this.ctx.channel(), null, "Negative SUBSCRIBE acknowledgement for an MQTT 3.1 client is not possible; the client was disconnected instead", Mqtt5DisconnectReasonCode.UNSPECIFIED_ERROR, null, Mqtt5UserProperties.NO_USER_PROPERTIES, false, true);
                return;
            }
            for (int i = 0; i < size; ++i) {
                reasonCodesBuilder.add(Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR);
            }
            this.ctx.writeAndFlush((Object)new SUBACK(output.getSubscribePacket().getPacketId(), reasonCodesBuilder, "SUBSCRIBE prevented by an extension."));
        }
    }
}

