/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.ClientContext;
import com.hivemq.extension.sdk.api.client.parameter.InitializerInput;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.services.intializer.ClientInitializer;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.client.ClientContextPluginImpl;
import com.hivemq.extensions.client.parameter.InitializerInputImpl;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.services.initializer.Initializers;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.publish.DefaultPermissionsEvaluator;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInitializerHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PluginInitializerHandler.class);
    @NotNull
    private final Initializers initializers;
    @NotNull
    private final PluginTaskExecutorService pluginTaskExecutorService;
    @NotNull
    private final ServerInformation serverInformation;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final MqttConnacker mqttConnacker;
    @Nullable
    private ClientContextImpl clientContext;
    @Nullable
    private InitializerInputImpl initializerInput;

    @Inject
    public PluginInitializerHandler(@NotNull Initializers initializers, @NotNull PluginTaskExecutorService pluginTaskExecutorService, @NotNull ServerInformation serverInformation, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull MqttConnacker mqttConnacker) {
        this.initializers = initializers;
        this.pluginTaskExecutorService = pluginTaskExecutorService;
        this.serverInformation = serverInformation;
        this.hiveMQExtensions = hiveMQExtensions;
        this.clientSessionPersistence = clientSessionPersistence;
        this.mqttConnacker = mqttConnacker;
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) throws Exception {
        if (msg instanceof CONNACK) {
            CONNACK connack = (CONNACK)msg;
            if (connack.getReasonCode() != Mqtt5ConnAckReasonCode.SUCCESS) {
                super.write(ctx, msg, promise);
                return;
            }
            this.fireInitialize(ctx, connack, promise);
            ctx.pipeline().remove((ChannelHandler)this);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void fireInitialize(final @NotNull ChannelHandlerContext ctx, final @Nullable CONNACK msg, final @NotNull ChannelPromise promise) {
        Map<String, ClientInitializer> pluginInitializerMap = this.initializers.getClientInitializerMap();
        final ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        if (pluginInitializerMap.isEmpty() && msg != null) {
            clientConnection.setPreventLwt(false);
            ctx.writeAndFlush((Object)msg, promise);
            clientConnection.setWillPublish(null);
            return;
        }
        if (!ctx.channel().isActive()) {
            return;
        }
        String clientId = clientConnection.getClientId();
        if (this.clientContext == null) {
            ModifiableDefaultPermissions defaultPermissions = clientConnection.getAuthPermissions();
            assert (defaultPermissions != null);
            this.clientContext = new ClientContextImpl(this.hiveMQExtensions, defaultPermissions);
        }
        if (this.initializerInput == null) {
            this.initializerInput = new InitializerInputImpl(this.serverInformation, ctx.channel(), clientId);
        }
        SettableFuture initializeFuture = SettableFuture.create();
        MultiInitializerTaskContext taskContext = new MultiInitializerTaskContext(clientId, ctx, (SettableFuture<Void>)initializeFuture, this.clientContext, pluginInitializerMap.size());
        for (Map.Entry<String, ClientInitializer> initializerEntry : pluginInitializerMap.entrySet()) {
            ClientInitializer initializer = initializerEntry.getValue();
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(initializer.getClass().getClassLoader());
            if (extension == null || extension.getExtensionClassloader() == null) {
                taskContext.finishInitializer();
                continue;
            }
            this.pluginTaskExecutorService.handlePluginInOutTaskExecution(taskContext, () -> this.initializerInput, () -> new ClientContextPluginImpl(extension.getExtensionClassloader(), this.clientContext), new InitializeTask(initializer, initializerEntry.getKey()));
        }
        Futures.addCallback((ListenableFuture)initializeFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                PluginInitializerHandler.this.authenticateWill(ctx, msg, promise);
                clientConnection.setWillPublish(null);
            }

            public void onFailure(@NotNull Throwable t) {
                Exceptions.rethrowError(t);
                log.error("Calling initializer failed", t);
                clientConnection.setWillPublish(null);
                ctx.writeAndFlush((Object)msg, promise);
            }
        }, (Executor)ctx.executor());
    }

    private void authenticateWill(final @NotNull ChannelHandlerContext ctx, @Nullable CONNACK msg, final @NotNull ChannelPromise promise) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        final MqttWillPublish willPublish = clientConnection.getWillPublish();
        if (willPublish == null) {
            ctx.writeAndFlush((Object)msg, promise);
            return;
        }
        ModifiableDefaultPermissions permissions = clientConnection.getAuthPermissions();
        if (DefaultPermissionsEvaluator.checkWillPublish(permissions, willPublish)) {
            clientConnection.setPreventLwt(false);
            ctx.writeAndFlush((Object)msg, promise);
            return;
        }
        clientConnection.setPreventLwt(true);
        ListenableFuture<Void> removeWillFuture = this.clientSessionPersistence.deleteWill(clientConnection.getClientId());
        Futures.addCallback(removeWillFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                this.sendConnackWillNotAuthorized();
            }

            public void onFailure(@NotNull Throwable t) {
                this.sendConnackWillNotAuthorized();
            }

            private void sendConnackWillNotAuthorized() {
                promise.setFailure((Throwable)new ClosedChannelException());
                PluginInitializerHandler.this.mqttConnacker.connackError(ctx.channel(), "A client (IP: {}) sent a CONNECT message with an not authorized Will Publish to topic '" + willPublish.getTopic() + "' with QoS '" + willPublish.getQos().getQosNumber() + "' and retain '" + willPublish.isRetain() + "'.", "sent a CONNECT message with an not authorized Will Publish to topic '" + willPublish.getTopic() + "' with QoS '" + willPublish.getQos().getQosNumber() + "' and retain '" + willPublish.isRetain() + "'", Mqtt5ConnAckReasonCode.NOT_AUTHORIZED, "Will Publish is not authorized to topic '" + willPublish.getTopic() + "' with QoS '" + String.valueOf((Object)willPublish.getQos()) + "' and retain '" + willPublish.isRetain() + "'", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
            }
        }, (Executor)ctx.executor());
    }

    private static class InitializeTask
    implements PluginInOutTask<InitializerInputImpl, ClientContextPluginImpl> {
        @NotNull
        private final ClientInitializer clientInitializer;
        @NotNull
        private final String pluginId;

        InitializeTask(@NotNull ClientInitializer clientInitializer, @NotNull String pluginId) {
            this.clientInitializer = clientInitializer;
            this.pluginId = pluginId;
        }

        @Override
        @NotNull
        public ClientContextPluginImpl apply(@NotNull InitializerInputImpl initializerInput, @NotNull ClientContextPluginImpl clientContext) {
            try {
                this.clientInitializer.initialize((InitializerInput)initializerInput, (ClientContext)clientContext);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on initialize. Extensions are responsible on their own to handle exceptions.", (Object)this.pluginId, (Object)e);
                Exceptions.rethrowError(e);
            }
            return clientContext;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.clientInitializer.getClass().getClassLoader();
        }
    }

    private static class MultiInitializerTaskContext
    extends PluginInOutTaskContext<ClientContextPluginImpl> {
        @NotNull
        private final ChannelHandlerContext channelHandlerContext;
        @NotNull
        private final SettableFuture<Void> initializeFuture;
        @NotNull
        private final ClientContextImpl clientContext;
        private final int initializerSize;
        @NotNull
        private final AtomicInteger counter = new AtomicInteger(0);

        MultiInitializerTaskContext(@NotNull String clientId, @NotNull ChannelHandlerContext channelHandlerContext, @NotNull SettableFuture<Void> initializeFuture, @NotNull ClientContextImpl clientContext, int clientInitializerCount) {
            super(clientId);
            this.channelHandlerContext = channelHandlerContext;
            this.initializeFuture = initializeFuture;
            this.initializerSize = clientInitializerCount;
            this.clientContext = clientContext;
        }

        @Override
        public void pluginPost(@NotNull ClientContextPluginImpl pluginContext) {
            this.finishInitializer();
        }

        public void finishInitializer() {
            try {
                if (this.counter.incrementAndGet() == this.initializerSize) {
                    ClientConnection clientConnection = ClientConnection.of(this.channelHandlerContext.channel());
                    clientConnection.setExtensionClientContext(this.clientContext);
                    clientConnection.setAuthPermissions(this.clientContext.getDefaultPermissions());
                    this.initializeFuture.set(null);
                }
            }
            catch (Exception e) {
                this.initializeFuture.setException((Throwable)e);
            }
        }
    }
}

