/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.unsubscribe.UnsubscribeInboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsubscribe.parameter.UnsubscribeInboundInput;
import com.hivemq.extension.sdk.api.interceptor.unsubscribe.parameter.UnsubscribeInboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.unsubscribe.parameter.UnsubscribeInboundInputImpl;
import com.hivemq.extensions.interceptor.unsubscribe.parameter.UnsubscribeInboundOutputImpl;
import com.hivemq.extensions.packets.unsubscribe.ModifiableUnsubscribePacketImpl;
import com.hivemq.extensions.packets.unsubscribe.UnsubscribePacketImpl;
import com.hivemq.mqtt.message.reason.Mqtt5UnsubAckReasonCode;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnsubscribeInboundInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(UnsubscribeInboundInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public UnsubscribeInboundInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleInboundUnsubscribe(@NotNull ChannelHandlerContext ctx, @NotNull UNSUBSCRIBE unsubscribe) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.fireChannelRead((Object)unsubscribe);
            return;
        }
        List<UnsubscribeInboundInterceptor> interceptors = clientContext.getUnsubscribeInboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.fireChannelRead((Object)unsubscribe);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        UnsubscribePacketImpl packet = new UnsubscribePacketImpl(unsubscribe);
        UnsubscribeInboundInputImpl input = new UnsubscribeInboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<UnsubscribeInboundInputImpl> inputHolder = new ExtensionParameterHolder<UnsubscribeInboundInputImpl>(input);
        ModifiableUnsubscribePacketImpl modifiablePacket = new ModifiableUnsubscribePacketImpl(packet, this.configurationService);
        UnsubscribeInboundOutputImpl output = new UnsubscribeInboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<UnsubscribeInboundOutputImpl> outputHolder = new ExtensionParameterHolder<UnsubscribeInboundOutputImpl>(output);
        UnsubscribeInboundInterceptorContext context = new UnsubscribeInboundInterceptorContext(clientId, interceptors.size(), ctx, inputHolder, outputHolder);
        for (UnsubscribeInboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            UnsubscribeInboundInterceptorTask task = new UnsubscribeInboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class UnsubscribeInboundInterceptorTask
    implements PluginInOutTask<UnsubscribeInboundInputImpl, UnsubscribeInboundOutputImpl> {
        @NotNull
        private final UnsubscribeInboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        UnsubscribeInboundInterceptorTask(@NotNull UnsubscribeInboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public UnsubscribeInboundOutputImpl apply(@NotNull UnsubscribeInboundInputImpl input, @NotNull UnsubscribeInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                return output;
            }
            try {
                this.interceptor.onInboundUnsubscribe((UnsubscribeInboundInput)input, (UnsubscribeInboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on inbound UNSUBSCRIBE interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.preventDelivery();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class UnsubscribeInboundInterceptorContext
    extends PluginInOutTaskContext<UnsubscribeInboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ExtensionParameterHolder<UnsubscribeInboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<UnsubscribeInboundOutputImpl> outputHolder;

        UnsubscribeInboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ExtensionParameterHolder<UnsubscribeInboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<UnsubscribeInboundOutputImpl> outputHolder) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull UnsubscribeInboundOutputImpl output) {
            if (output.isPreventDelivery()) {
                this.finishInterceptor();
            } else if (output.isTimedOut() && output.getTimeoutFallback() == TimeoutFallback.FAILURE) {
                output.preventDelivery();
                this.finishInterceptor();
            } else {
                if (output.getUnsubscribePacket().isModified()) {
                    this.inputHolder.set(this.inputHolder.get().update(output));
                }
                if (!this.finishInterceptor()) {
                    this.outputHolder.set(output.update(this.inputHolder.get()));
                }
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            UnsubscribeInboundOutputImpl output = this.outputHolder.get();
            if (output.isPreventDelivery()) {
                this.prevent(output);
            } else {
                UNSUBSCRIBE unsubscribe = UNSUBSCRIBE.from(this.inputHolder.get().getUnsubscribePacket());
                this.ctx.fireChannelRead((Object)unsubscribe);
            }
        }

        private void prevent(@NotNull UnsubscribeInboundOutputImpl output) {
            int size = output.getUnsubscribePacket().getTopicFilters().size();
            ImmutableList.Builder reasonCodesBuilder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                reasonCodesBuilder.add((Object)Mqtt5UnsubAckReasonCode.UNSPECIFIED_ERROR);
            }
            this.ctx.channel().writeAndFlush((Object)new UNSUBACK(output.getUnsubscribePacket().getPacketIdentifier(), (List<Mqtt5UnsubAckReasonCode>)reasonCodesBuilder.build(), "UNSUBSCRIBE prevented by an extension."));
        }
    }
}

