/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerOutputImpl;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import java.util.concurrent.atomic.AtomicInteger;

public class SubscriptionAuthorizerContext
extends PluginInOutTaskContext<SubscriptionAuthorizerOutputImpl> {
    @NotNull
    private final SubscriptionAuthorizerOutputImpl output;
    @NotNull
    private final SettableFuture<SubscriptionAuthorizerOutputImpl> authorizeFuture;
    private final int authorizerCount;
    @NotNull
    private final AtomicInteger counter;

    public SubscriptionAuthorizerContext(@NotNull String identifier, @NotNull SubscriptionAuthorizerOutputImpl output, @NotNull SettableFuture<SubscriptionAuthorizerOutputImpl> authorizeFuture, int authorizerCount) {
        super(identifier);
        this.output = output;
        this.authorizeFuture = authorizeFuture;
        this.authorizerCount = authorizerCount;
        this.counter = new AtomicInteger(0);
    }

    @Override
    public void pluginPost(@NotNull SubscriptionAuthorizerOutputImpl pluginOutput) {
        if (pluginOutput.isAsync() && pluginOutput.isTimedOut() && pluginOutput.getTimeoutFallback() == TimeoutFallback.FAILURE) {
            pluginOutput.forceFailedAuthorization();
        }
        if (pluginOutput.isCompleted()) {
            this.authorizeFuture.set((Object)pluginOutput);
            return;
        }
        if (this.counter.incrementAndGet() == this.authorizerCount) {
            this.authorizeFuture.set((Object)pluginOutput);
        }
    }

    public void increment() {
        if (this.counter.incrementAndGet() == this.authorizerCount) {
            this.authorizeFuture.set((Object)this.output);
        }
    }
}

