/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.ChunkResult;
import java.util.Collection;

@ThreadSafe
public class ResultBuffer<V> {
    private ChunkResult<V> currentChunk = null;
    @NotNull
    private final NextChunkCallback<V> nextChunkCallback;

    ResultBuffer(@NotNull NextChunkCallback<V> nextChunkCallback) {
        this.nextChunkCallback = nextChunkCallback;
    }

    synchronized void addChunk(@NotNull ChunkResult<V> chunk) {
        this.currentChunk = chunk;
    }

    @Nullable
    synchronized Collection<V> getNextChunk() {
        if (this.currentChunk == null) {
            return null;
        }
        ChunkResult<V> chunkResult = this.currentChunk;
        this.currentChunk = null;
        if (!chunkResult.isFinished()) {
            this.nextChunkCallback.fetchNextChunk(chunkResult.getCursor(), this);
        }
        return chunkResult.getResults();
    }

    public synchronized void clean() {
        this.currentChunk = null;
    }

    public static interface NextChunkCallback<V> {
        public void fetchNextChunk(@Nullable ChunkCursor var1, @NotNull ResultBuffer<V> var2);
    }
}

