/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.loader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.hivemq.HiveMQServer;
import com.hivemq.annotations.ReadOnly;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.extension.sdk.api.ExtensionMain;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.ExtensionUtil;
import com.hivemq.extensions.HiveMQEmbeddedExtensionImpl;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensionEntity;
import com.hivemq.extensions.HiveMQExtensionEvent;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.classloader.IsolatedExtensionClassloader;
import com.hivemq.extensions.config.HiveMQExtensionXMLReader;
import com.hivemq.extensions.exception.ExtensionLoadingException;
import com.hivemq.extensions.loader.ClassServiceLoader;
import com.hivemq.extensions.loader.ExtensionLoader;
import com.hivemq.extensions.loader.ExtensionStaticInitializer;
import com.hivemq.extensions.loader.HiveMQExtensionFactory;
import com.hivemq.util.Exceptions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExtensionLoaderImpl
implements ExtensionLoader {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLoaderImpl.class);
    @NotNull
    private final ClassServiceLoader serviceLoader;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final HiveMQExtensionFactory hiveMQExtensionFactory;
    @NotNull
    private final ExtensionStaticInitializer staticInitializer;

    @Inject
    @VisibleForTesting
    public ExtensionLoaderImpl(@NotNull ClassServiceLoader serviceLoader, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull HiveMQExtensionFactory hiveMQExtensionFactory, @NotNull ExtensionStaticInitializer staticInitializer) {
        this.serviceLoader = serviceLoader;
        this.hiveMQExtensions = hiveMQExtensions;
        this.hiveMQExtensionFactory = hiveMQExtensionFactory;
        this.staticInitializer = staticInitializer;
    }

    @ReadOnly
    @NotNull
    public ImmutableSet<HiveMQExtensionEvent> loadExtensions(@NotNull Path extensionFolder, boolean permissive) {
        Preconditions.checkNotNull((Object)extensionFolder, (Object)"extension folder must not be null");
        try {
            Preconditions.checkArgument((boolean)Files.exists(extensionFolder, new LinkOption[0]), (String)"%s does not exist", (Object)extensionFolder.toAbsolutePath());
            Preconditions.checkArgument((boolean)Files.isReadable(extensionFolder), (String)"%s is not readable", (Object)extensionFolder.toAbsolutePath());
            Preconditions.checkArgument((boolean)Files.isDirectory(extensionFolder, new LinkOption[0]), (String)"%s is not a directory", (Object)extensionFolder.toAbsolutePath());
        }
        catch (IllegalArgumentException exception) {
            if (permissive) {
                log.warn("Extension folder could not be used: \"{}\"", (Object)exception.getMessage());
                return ImmutableSet.of();
            }
            throw exception;
        }
        ImmutableSet.Builder extensions = ImmutableSet.builder();
        try {
            List<Path> folders = ExtensionUtil.findAllExtensionFolders(extensionFolder);
            for (Path folder : folders) {
                HiveMQExtensionEvent hivemqExtension = this.processSingleExtensionFolder(folder);
                if (hivemqExtension == null) continue;
                extensions.add((Object)hivemqExtension);
            }
        }
        catch (IOException e) {
            log.error("Could not read extensions. Original exception:", (Throwable)e);
        }
        return extensions.build();
    }

    @Override
    @VisibleForTesting
    @Nullable
    public HiveMQExtensionEvent processSingleExtensionFolder(@NotNull Path extensionFolder) {
        boolean folderEnabled;
        Optional<HiveMQExtensionEntity> xmlEntityOptional = HiveMQExtensionXMLReader.getExtensionEntityFromXML(extensionFolder, true);
        if (xmlEntityOptional.isEmpty()) {
            return null;
        }
        HiveMQExtensionEntity xmlEntity = xmlEntityOptional.get();
        String[] folderContents = extensionFolder.toFile().list();
        if (folderContents == null || folderContents.length < 1) {
            return null;
        }
        boolean bl = folderEnabled = !extensionFolder.resolve("DISABLED").toFile().exists();
        if (this.hiveMQExtensions.isHiveMQExtensionKnown(xmlEntity.getId(), extensionFolder, folderEnabled)) {
            return null;
        }
        boolean extensionEnabled = this.hiveMQExtensions.isHiveMQExtensionEnabled(xmlEntity.getId());
        if (!folderEnabled && !extensionEnabled) {
            return null;
        }
        String fileName = extensionFolder.getFileName().toString();
        if (!fileName.equals(xmlEntity.getId())) {
            log.warn("Found extension directory name not matching to id, ignoring extension with id \"{}\" at {}", (Object)xmlEntity.getId(), (Object)extensionFolder);
            return null;
        }
        if (!folderEnabled) {
            return new HiveMQExtensionEvent(HiveMQExtensionEvent.Change.DISABLE, xmlEntity.getId(), xmlEntity.getStartPriority(), extensionFolder, false);
        }
        if (this.hiveMQExtensions.isHiveMQExtensionIDKnown(xmlEntity.getId()) && extensionEnabled) {
            log.warn("An extension with id \"{}\" is already loaded, ignoring extension at {}", (Object)xmlEntity.getId(), (Object)extensionFolder);
            return null;
        }
        HiveMQExtension hiveMQExtension = this.loadSingleExtension(extensionFolder, xmlEntity);
        if (hiveMQExtension == null) {
            return null;
        }
        this.hiveMQExtensions.addHiveMQExtension(hiveMQExtension);
        return new HiveMQExtensionEvent(HiveMQExtensionEvent.Change.ENABLE, hiveMQExtension.getId(), hiveMQExtension.getStartPriority(), extensionFolder, false);
    }

    @Override
    @Nullable
    public HiveMQExtensionEvent loadEmbeddedExtension(@NotNull EmbeddedExtension embeddedExtension) {
        HiveMQEmbeddedExtensionImpl extension = new HiveMQEmbeddedExtensionImpl(embeddedExtension.getId(), embeddedExtension.getVersion(), embeddedExtension.getName(), embeddedExtension.getAuthor(), embeddedExtension.getPriority(), embeddedExtension.getStartPriority(), embeddedExtension.getExtensionMain(), true);
        HiveMQExtensionEvent hiveMQExtensionEvent = new HiveMQExtensionEvent(HiveMQExtensionEvent.Change.ENABLE, embeddedExtension.getId(), embeddedExtension.getStartPriority(), extension.getExtensionFolderPath(), true);
        this.hiveMQExtensions.addHiveMQExtension(extension);
        ClassLoader extensionClassloader = extension.getExtensionClassloader();
        if (extensionClassloader == null) {
            throw new IllegalStateException("The extensions class loader must not be null at loading stage");
        }
        IsolatedExtensionClassloader isolatedExtensionClassloader = new IsolatedExtensionClassloader(extensionClassloader, HiveMQServer.class.getClassLoader());
        isolatedExtensionClassloader.loadClassesWithStaticContext();
        try {
            this.staticInitializer.initialize(embeddedExtension.getId(), extensionClassloader);
        }
        catch (ExtensionLoadingException e) {
            log.warn("Embedded extension with id \"{}\" cannot be started, the extension will be disabled. reason: {}", (Object)embeddedExtension.getId(), (Object)e.getMessage());
            log.debug("Original exception", (Throwable)e);
            Exceptions.rethrowError(e);
            return null;
        }
        return hiveMQExtensionEvent;
    }

    @VisibleForTesting
    @Nullable
    HiveMQExtension loadSingleExtension(@NotNull Path extensionFolder, @NotNull HiveMQExtensionEntity xmlEntity) {
        ImmutableList.Builder jarPaths = ImmutableList.builder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(extensionFolder);){
            for (Path path : stream) {
                if (!path.toString().endsWith(".jar")) continue;
                log.trace("Found extension jar {}", (Object)path);
                jarPaths.add((Object)path);
            }
        }
        catch (IOException e) {
            if (log.isTraceEnabled()) {
                log.trace("Could not read extension folder {}. Original exception:", (Object)extensionFolder, (Object)e);
            }
            return null;
        }
        ImmutableList.Builder urls = ImmutableList.builder();
        for (Path path : jarPaths.build()) {
            try {
                urls.add((Object)path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                log.warn("Could not add " + String.valueOf(path.toAbsolutePath()) + " to the list of files considered for extension discovery");
                log.debug("Original exception:", (Throwable)e);
            }
        }
        Optional<Class<? extends ExtensionMain>> classOptional = this.loadFromUrls((Collection<URL>)urls.build(), xmlEntity.getId());
        if (classOptional.isEmpty()) {
            try {
                ExtensionUtil.disableExtensionFolder(extensionFolder);
            }
            catch (IOException e) {
                log.warn("An extension in folder \"" + String.valueOf(extensionFolder) + "\" could not be disabled: ", (Throwable)e);
            }
            return null;
        }
        Class<? extends ExtensionMain> extensionMainClass = classOptional.get();
        try {
            ExtensionMain instance = extensionMainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.hiveMQExtensionFactory.createHiveMQExtension(instance, extensionFolder, xmlEntity, true);
        }
        catch (NoSuchMethodException e) {
            log.warn("Extension {} cannot be loaded. The {} has no constructor without parameters, a no-arg constructor for a ExtensionMain is required by HiveMQ.", (Object)extensionFolder.toAbsolutePath(), extensionMainClass);
        }
        catch (Throwable t) {
            log.warn("Extension {} cannot be loaded. The class {} cannot be instantiated, reason: {}", new Object[]{extensionFolder.toAbsolutePath(), extensionMainClass.getCanonicalName(), t.getMessage()});
            log.debug("Original exception:", t);
        }
        try {
            ((IsolatedExtensionClassloader)extensionMainClass.getClassLoader()).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    Optional<Class<? extends ExtensionMain>> loadFromUrls(@NotNull Collection<URL> urls, @NotNull String extensionId) {
        Preconditions.checkNotNull(urls, (Object)"urls must not be null");
        if (urls.isEmpty()) {
            return Optional.empty();
        }
        TypeToken type = TypeToken.of(ExtensionMain.class);
        ImmutableList.Builder desiredExtensions = ImmutableList.builder();
        try {
            ImmutableList.Builder allImplementations = ImmutableList.builder();
            for (URL extensionFileUrl : urls) {
                URL[] classpath = new URL[]{extensionFileUrl};
                IsolatedExtensionClassloader extensionClassloader = new IsolatedExtensionClassloader(classpath, this.getClass().getClassLoader());
                extensionClassloader.loadClassesWithStaticContext();
                if (!this.initializeStaticContext(extensionId, extensionClassloader)) {
                    return Optional.empty();
                }
                Iterable<Class<ExtensionMain>> allExtensionModuleStartingPoints = this.serviceLoader.load(ExtensionMain.class, extensionClassloader);
                if (Iterables.size(allExtensionModuleStartingPoints) > 1) {
                    log.warn("Extension {} contains more than one implementation of ExtensionMain. The extension will be disabled.", (Object)extensionFileUrl.toString());
                    return Optional.empty();
                }
                for (Class<ExtensionMain> startingPoint : allExtensionModuleStartingPoints) {
                    allImplementations.add(startingPoint);
                }
            }
            for (Class implementation : allImplementations.build()) {
                if (type.getRawType().isAssignableFrom(implementation)) {
                    desiredExtensions.add((Object)implementation);
                    continue;
                }
                log.debug("Extension {} is not a {} Extension and will be ignored", (Object)implementation.getName(), (Object)type.getRawType().getName());
            }
        }
        catch (Throwable t) {
            log.error("An error occurred while searching the implementations for the extension {}. The extension will be disabled. {} : {}", new Object[]{extensionId, t.getClass().getSimpleName(), t.getMessage()});
            return Optional.empty();
        }
        ImmutableList desired = desiredExtensions.build();
        if (desired.size() == 1) {
            return Optional.of((Class)desired.get(0));
        }
        if (desired.size() == 0) {
            log.warn("No implementation of the interface ExtensionMain found in the extension with id \"{}\". The extension will be disabled.", (Object)extensionId);
            return Optional.empty();
        }
        log.error("More than one implementation of the interface ExtensionMain found in extension with id {}, this interface can only be implemented once. The extension will be disabled.", (Object)extensionId);
        return Optional.empty();
    }

    private boolean initializeStaticContext(@NotNull String hiveMQExtensionID, @NotNull IsolatedExtensionClassloader classloader) {
        try {
            this.staticInitializer.initialize(hiveMQExtensionID, classloader);
        }
        catch (Throwable e) {
            log.warn("Extension with id \"{}\" cannot be started, the extension will be disabled. reason: {}", (Object)hiveMQExtensionID, (Object)e.getMessage());
            log.debug("Original exception", e);
            Exceptions.rethrowError(e);
            return false;
        }
        return true;
    }
}

