/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.services.Services;
import com.hivemq.extension.sdk.api.services.builder.Builders;
import com.hivemq.extensions.exception.ExtensionLoadingException;
import com.hivemq.extensions.loader.ExtensionBuilderDependencies;
import com.hivemq.extensions.loader.ExtensionServicesDependencies;
import com.hivemq.extensions.loader.ExtensionStaticInitializer;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExtensionStaticInitializerImpl
implements ExtensionStaticInitializer {
    private static final String SERVICES_CLASS = Services.class.getCanonicalName();
    private static final String BUILDERS_CLASS = Builders.class.getCanonicalName();
    @NotNull
    private final ExtensionServicesDependencies servicesDependencies;
    @NotNull
    private final ExtensionBuilderDependencies builderDependencies;

    @Inject
    public ExtensionStaticInitializerImpl(@NotNull ExtensionServicesDependencies servicesDependencies, @NotNull ExtensionBuilderDependencies builderDependencies) {
        this.servicesDependencies = servicesDependencies;
        this.builderDependencies = builderDependencies;
    }

    @Override
    public void initialize(@NotNull String pluginId, @NotNull ClassLoader classLoader) throws ExtensionLoadingException {
        Preconditions.checkNotNull((Object)pluginId, (Object)"extension id must not be null");
        Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader must not be null");
        this.initializeServices(pluginId, classLoader);
        this.initializeBuilders(pluginId, classLoader);
    }

    private void initializeServices(@NotNull String pluginId, @NotNull ClassLoader classLoader) throws ExtensionLoadingException {
        try {
            Class<?> servicesClass = classLoader.loadClass(SERVICES_CLASS);
            Field servicesField = servicesClass.getDeclaredField("services");
            servicesField.setAccessible(true);
            ImmutableMap<String, Object> dependencies = this.servicesDependencies.getDependenciesMap(classLoader);
            servicesField.set(null, dependencies);
        }
        catch (Exception e) {
            throw new ExtensionLoadingException("Not able to initialize Services for extension with id " + pluginId, e);
        }
    }

    private void initializeBuilders(@NotNull String pluginId, @NotNull ClassLoader classLoader) throws ExtensionLoadingException {
        try {
            Class<?> buildersClass = classLoader.loadClass(BUILDERS_CLASS);
            Field buildersField = buildersClass.getDeclaredField("builders");
            buildersField.setAccessible(true);
            ImmutableMap<String, Supplier<Object>> dependencies = this.builderDependencies.getDependenciesMap();
            buildersField.set(null, dependencies);
        }
        catch (Exception e) {
            throw new ExtensionLoadingException("Not able to initialize Builders for extension with id " + pluginId, e);
        }
    }
}

