/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.connect;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connect.ConnectPacket;
import com.hivemq.extension.sdk.api.packets.connect.WillPublishPacket;
import com.hivemq.extension.sdk.api.packets.general.MqttVersion;
import com.hivemq.extensions.packets.general.MqttVersionUtil;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.packets.publish.WillPublishPacketImpl;
import com.hivemq.mqtt.message.connect.CONNECT;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

public class ConnectPacketImpl
implements ConnectPacket {
    @NotNull
    final MqttVersion mqttVersion;
    @NotNull
    final String clientId;
    final boolean cleanStart;
    final long sessionExpiryInterval;
    final int keepAlive;
    final int receiveMaximum;
    final long maximumPacketSize;
    final int topicAliasMaximum;
    final boolean requestProblemInformation;
    final boolean requestResponseInformation;
    @Nullable
    final String userName;
    @Nullable
    final ByteBuffer password;
    @Nullable
    final String authenticationMethod;
    @Nullable
    final ByteBuffer authenticationData;
    @Nullable
    final WillPublishPacketImpl willPublish;
    @NotNull
    final UserPropertiesImpl userProperties;

    public ConnectPacketImpl(@NotNull MqttVersion mqttVersion, @NotNull String clientId, boolean cleanStart, long sessionExpiryInterval, int keepAlive, int receiveMaximum, long maximumPacketSize, int topicAliasMaximum, boolean requestProblemInformation, boolean requestResponseInformation, @Nullable String userName, @Nullable ByteBuffer password, @Nullable String authenticationMethod, @Nullable ByteBuffer authenticationData, @Nullable WillPublishPacketImpl willPublish, @NotNull UserPropertiesImpl userProperties) {
        this.mqttVersion = mqttVersion;
        this.clientId = clientId;
        this.cleanStart = cleanStart;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.keepAlive = keepAlive;
        this.receiveMaximum = receiveMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMaximum = topicAliasMaximum;
        this.requestProblemInformation = requestProblemInformation;
        this.requestResponseInformation = requestResponseInformation;
        this.userName = userName;
        this.password = password;
        this.authenticationMethod = authenticationMethod;
        this.authenticationData = authenticationData;
        this.willPublish = willPublish;
        this.userProperties = userProperties;
    }

    public ConnectPacketImpl(@NotNull CONNECT connect, long timestamp) {
        this(MqttVersionUtil.toMqttVersion(connect.getProtocolVersion()), connect.getClientIdentifier(), connect.isCleanStart(), connect.getSessionExpiryInterval(), connect.getKeepAlive(), connect.getReceiveMaximum(), connect.getMaximumPacketSize(), connect.getTopicAliasMaximum(), connect.isProblemInformationRequested(), connect.isResponseInformationRequested(), connect.getUsername(), connect.getPassword() == null ? null : ByteBuffer.wrap(connect.getPassword()), connect.getAuthMethod(), connect.getAuthData() == null ? null : ByteBuffer.wrap(connect.getAuthData()), connect.getWillPublish() == null ? null : new WillPublishPacketImpl(connect.getWillPublish(), timestamp), UserPropertiesImpl.of(connect.getUserProperties().asList()));
    }

    @NotNull
    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    public boolean getCleanStart() {
        return this.cleanStart;
    }

    public long getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public boolean getRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    public boolean getRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    @NotNull
    public Optional<String> getUserName() {
        return Optional.ofNullable(this.userName);
    }

    @NotNull
    public Optional<ByteBuffer> getPassword() {
        return this.password == null ? Optional.empty() : Optional.of(this.password.asReadOnlyBuffer());
    }

    @NotNull
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(this.authenticationMethod);
    }

    @NotNull
    public Optional<ByteBuffer> getAuthenticationData() {
        return this.authenticationData == null ? Optional.empty() : Optional.of(this.authenticationData.asReadOnlyBuffer());
    }

    @NotNull
    public Optional<WillPublishPacket> getWillPublish() {
        return Optional.ofNullable(this.willPublish);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectPacketImpl)) {
            return false;
        }
        ConnectPacketImpl that = (ConnectPacketImpl)o;
        return this.mqttVersion == that.mqttVersion && this.clientId.equals(that.clientId) && this.cleanStart == that.cleanStart && this.sessionExpiryInterval == that.sessionExpiryInterval && this.keepAlive == that.keepAlive && this.receiveMaximum == that.receiveMaximum && this.maximumPacketSize == that.maximumPacketSize && this.topicAliasMaximum == that.topicAliasMaximum && this.requestProblemInformation == that.requestProblemInformation && this.requestResponseInformation == that.requestResponseInformation && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.authenticationMethod, that.authenticationMethod) && Objects.equals(this.authenticationData, that.authenticationData) && Objects.equals(this.willPublish, that.willPublish) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.mqttVersion, this.clientId, this.cleanStart, this.sessionExpiryInterval, this.keepAlive, this.receiveMaximum, this.maximumPacketSize, this.topicAliasMaximum, this.requestProblemInformation, this.requestResponseInformation, this.userName, this.password, this.authenticationMethod, this.authenticationData, this.willPublish, this.userProperties);
    }
}

