/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.general;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.general.ModifiableUserProperties;
import com.hivemq.extension.sdk.api.packets.general.UserProperty;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@ThreadSafe
public class ModifiableUserPropertiesImpl
implements ModifiableUserProperties {
    @NotNull
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    @NotNull
    private List<MqttUserProperty> list;
    private final boolean validateUTF8;
    private boolean modified = false;

    public ModifiableUserPropertiesImpl(@NotNull ImmutableList<MqttUserProperty> list, boolean validateUTF8) {
        this.list = list;
        this.validateUTF8 = validateUTF8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<String> getFirst(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must never be null");
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            Optional<String> optional = this.list.stream().filter(userProperty -> userProperty.getName().equals(name)).findFirst().map(UserProperty::getValue);
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getAllForName(@NotNull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name must never be null");
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            List list = (List)this.list.stream().filter(userProperty -> userProperty.getName().equals(name)).map(UserProperty::getValue).collect(ImmutableList.toImmutableList());
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public ImmutableList<UserProperty> asList() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.list);
            return immutableList;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public ImmutableList<MqttUserProperty> asInternalList() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.list);
            return immutableList;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            boolean bl = this.list.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void addUserProperty(@NotNull UserProperty userProperty) {
        Preconditions.checkNotNull((Object)userProperty, (Object)"User property must never be null");
        if (!(userProperty instanceof MqttUserProperty)) {
            throw new DoNotImplementException(UserProperty.class.getSimpleName());
        }
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.modify().add((MqttUserProperty)userProperty);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserProperty(@NotNull String name, @NotNull String value) {
        PluginBuilderUtil.checkUserProperty(name, value, this.validateUTF8);
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.modify().add(new MqttUserProperty(name, value));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserProperty(@NotNull String name, @NotNull String value) {
        PluginBuilderUtil.checkUserProperty(name, value, this.validateUTF8);
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.modify().remove(new MqttUserProperty(name, value));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<UserProperty> removeName(@NotNull String name) {
        PluginBuilderUtil.checkUserPropertyName(name, this.validateUTF8);
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            ImmutableList.Builder removed = ImmutableList.builder();
            this.modify().removeIf(userProperty -> {
                if (userProperty.getName().equals(name)) {
                    removed.add(userProperty);
                    return true;
                }
                return false;
            });
            ImmutableList immutableList = removed.build();
            return immutableList;
        }
        finally {
            lock.unlock();
        }
    }

    public void clear() {
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.modified = true;
            this.list = new LinkedList<MqttUserProperty>();
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public UserPropertiesImpl copy() {
        return UserPropertiesImpl.of(this.asInternalList());
    }

    @NotNull
    private LinkedList<MqttUserProperty> modify() {
        if (this.list instanceof LinkedList) {
            return (LinkedList)this.list;
        }
        this.modified = true;
        LinkedList<MqttUserProperty> modifiableList = new LinkedList<MqttUserProperty>(this.list);
        this.list = modifiableList;
        return modifiableList;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableUserPropertiesImpl)) {
            return false;
        }
        ModifiableUserPropertiesImpl that = (ModifiableUserPropertiesImpl)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }
}

