/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.pubcomp;

import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubcomp.ModifiablePubcompPacket;
import com.hivemq.extension.sdk.api.packets.pubcomp.PubcompReasonCode;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.pubcomp.PubcompPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import java.util.Objects;
import java.util.Optional;

public class ModifiablePubcompPacketImpl
implements ModifiablePubcompPacket {
    private final int packetIdentifier;
    @NotNull
    private final PubcompReasonCode reasonCode;
    @Nullable
    private String reasonString;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiablePubcompPacketImpl(@NotNull PubcompPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.packetIdentifier = packet.packetIdentifier;
        this.reasonCode = packet.reasonCode;
        this.reasonString = packet.reasonString;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public PubcompReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public PubcompPacketImpl copy() {
        return new PubcompPacketImpl(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties.copy());
    }

    @NotNull
    public ModifiablePubcompPacketImpl update(@NotNull PubcompPacketImpl packet) {
        return new ModifiablePubcompPacketImpl(packet, this.configurationService);
    }
}

