/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.pubcomp;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.pubcomp.PubcompPacket;
import com.hivemq.extension.sdk.api.packets.pubcomp.PubcompReasonCode;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import com.hivemq.mqtt.message.reason.Mqtt5PubCompReasonCode;
import java.util.Objects;
import java.util.Optional;

public class PubcompPacketImpl
implements PubcompPacket {
    final int packetIdentifier;
    @NotNull
    final PubcompReasonCode reasonCode;
    @Nullable
    final String reasonString;
    @NotNull
    final UserPropertiesImpl userProperties;

    public PubcompPacketImpl(int packetIdentifier, @NotNull PubcompReasonCode reasonCode, @Nullable String reasonString, @NotNull UserPropertiesImpl userProperties) {
        this.packetIdentifier = packetIdentifier;
        this.reasonCode = reasonCode;
        this.reasonString = reasonString;
        this.userProperties = userProperties;
    }

    public PubcompPacketImpl(@NotNull PUBCOMP pubcomp) {
        this(pubcomp.getPacketIdentifier(), ((Mqtt5PubCompReasonCode)pubcomp.getReasonCode()).toPubcompReasonCode(), pubcomp.getReasonString(), UserPropertiesImpl.of(pubcomp.getUserProperties().asList()));
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public PubcompReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    @NotNull
    public UserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PubcompPacketImpl)) {
            return false;
        }
        PubcompPacketImpl that = (PubcompPacketImpl)o;
        return this.packetIdentifier == that.packetIdentifier && this.reasonCode == that.reasonCode && Objects.equals(this.reasonString, that.reasonString) && this.userProperties.equals(that.userProperties);
    }

    public int hashCode() {
        return Objects.hash(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties);
    }
}

