/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.publish;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.annotations.ThreadSafe;
import com.hivemq.extension.sdk.api.packets.publish.ModifiableWillPublish;
import com.hivemq.extensions.packets.publish.ModifiablePublishPacketImpl;
import com.hivemq.extensions.packets.publish.WillPublishPacketImpl;
import java.util.Objects;

@ThreadSafe
public class ModifiableWillPublishImpl
extends ModifiablePublishPacketImpl
implements ModifiableWillPublish {
    private long willDelay;

    public ModifiableWillPublishImpl(@NotNull WillPublishPacketImpl willPublishPacket, @NotNull FullConfigurationService configurationService) {
        super(willPublishPacket, configurationService);
        this.willDelay = willPublishPacket.willDelay;
    }

    public long getWillDelay() {
        return this.willDelay;
    }

    public void setWillDelay(long willDelay) {
        Preconditions.checkArgument((willDelay >= 0L ? 1 : 0) != 0, (Object)"Will delay must NOT be less than 0");
        Preconditions.checkArgument((willDelay < 0xFFFFFFFFL ? 1 : 0) != 0, (Object)"Will delay must be less than 4294967295");
        if (this.willDelay == willDelay) {
            return;
        }
        this.willDelay = willDelay;
        this.modified = true;
    }

    @Override
    @NotNull
    public WillPublishPacketImpl copy() {
        return new WillPublishPacketImpl(this.topic, this.qos, this.payload, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, this.userProperties.copy(), this.willDelay, this.timestamp);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableWillPublishImpl) || !super.equals(o)) {
            return false;
        }
        ModifiableWillPublishImpl that = (ModifiableWillPublishImpl)o;
        return this.willDelay == that.willDelay;
    }

    @Override
    protected boolean canEqual(@Nullable Object o) {
        return o instanceof ModifiableWillPublishImpl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.willDelay);
    }
}

