/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.pubrec;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extension.sdk.api.packets.pubrec.ModifiablePubrecPacket;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.pubrec.PubrecPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.reason.Mqtt5PubRecReasonCode;
import java.util.Objects;
import java.util.Optional;

public class ModifiablePubrecPacketImpl
implements ModifiablePubrecPacket {
    private final int packetIdentifier;
    @NotNull
    private AckReasonCode reasonCode;
    @Nullable
    private String reasonString;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiablePubrecPacketImpl(@NotNull PubrecPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.packetIdentifier = packet.packetIdentifier;
        this.reasonCode = packet.reasonCode;
        this.reasonString = packet.reasonString;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public AckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(@NotNull AckReasonCode reasonCode) {
        Preconditions.checkNotNull((Object)reasonCode, (Object)"Reason code must never be null");
        if (this.reasonCode == reasonCode) {
            return;
        }
        Mqtt5PubRecReasonCode newReasonCode = Mqtt5PubRecReasonCode.from(reasonCode);
        Mqtt5PubRecReasonCode oldReasonCode = Mqtt5PubRecReasonCode.from(this.reasonCode);
        boolean switched = newReasonCode.isError() != oldReasonCode.isError();
        Preconditions.checkState((!switched ? 1 : 0) != 0, (Object)"Reason code must not switch from successful to unsuccessful or vice versa");
        this.reasonCode = reasonCode;
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public PubrecPacketImpl copy() {
        return new PubrecPacketImpl(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties.copy());
    }

    @NotNull
    public ModifiablePubrecPacketImpl update(@NotNull PubrecPacketImpl pubrecPacket) {
        return new ModifiablePubrecPacketImpl(pubrecPacket, this.configurationService);
    }
}

