/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.suback;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.suback.ModifiableSubackPacket;
import com.hivemq.extension.sdk.api.packets.subscribe.SubackReasonCode;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.suback.SubackPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ModifiableSubackPacketImpl
implements ModifiableSubackPacket {
    @NotNull
    private ImmutableList<SubackReasonCode> reasonCodes;
    @Nullable
    private String reasonString;
    private final int packetIdentifier;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableSubackPacketImpl(@NotNull SubackPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.reasonCodes = packet.reasonCodes;
        this.reasonString = packet.reasonString;
        this.packetIdentifier = packet.packetIdentifier;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    @NotNull
    public ImmutableList<SubackReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    public void setReasonCodes(@NotNull @NotNull List<@NotNull SubackReasonCode> reasonCodes) {
        Preconditions.checkNotNull(reasonCodes, (Object)"Reason codes must never be null.");
        if (reasonCodes.size() != this.reasonCodes.size()) {
            throw new IllegalArgumentException("The amount of reason codes must not be changed.");
        }
        for (int i = 0; i < reasonCodes.size(); ++i) {
            Preconditions.checkNotNull((Object)reasonCodes.get(i), (String)"Reason code (at index %s) must never be null.", (int)i);
            Mqtt5SubAckReasonCode oldReasonCode = Mqtt5SubAckReasonCode.from((SubackReasonCode)this.reasonCodes.get(i));
            Mqtt5SubAckReasonCode newReasonCode = Mqtt5SubAckReasonCode.from(reasonCodes.get(i));
            Preconditions.checkState((newReasonCode.isError() == oldReasonCode.isError() ? 1 : 0) != 0, (String)"Reason code (at index %s) must not switch from successful to unsuccessful or vice versa.", (int)i);
        }
        if (Objects.equals(this.reasonCodes, reasonCodes)) {
            return;
        }
        this.reasonCodes = ImmutableList.copyOf(reasonCodes);
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public SubackPacketImpl copy() {
        return new SubackPacketImpl(this.reasonCodes, this.reasonString, this.packetIdentifier, this.userProperties.copy());
    }

    @NotNull
    public ModifiableSubackPacketImpl update(@NotNull SubackPacketImpl packet) {
        return new ModifiableSubackPacketImpl(packet, this.configurationService);
    }
}

